/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLServerSocketWrapper;
import org.apache.commons.ssl.SSLSocketWrapper;

public interface SSLWrapperFactory {
    public static final SSLWrapperFactory NO_WRAP = new SSLWrapperFactory(){

        public SSLSocket wrap(SSLSocket s) {
            return s;
        }

        public SSLServerSocket wrap(SSLServerSocket s, SSL ssl) throws IOException {
            boolean java13 = JavaImpl.isJava13();
            return java13 ? s : new SSLServerSocketWrapper(s, ssl, this);
        }
    };
    public static final SSLWrapperFactory DUMB_WRAP = new SSLWrapperFactory(){

        public SSLSocket wrap(SSLSocket s) {
            return new SSLSocketWrapper(s);
        }

        public SSLServerSocket wrap(SSLServerSocket s, SSL ssl) throws IOException {
            boolean java13 = JavaImpl.isJava13();
            return java13 ? s : new SSLServerSocketWrapper(s, ssl, this);
        }
    };

    public SSLSocket wrap(SSLSocket var1) throws IOException;

    public SSLServerSocket wrap(SSLServerSocket var1, SSL var2) throws IOException;
}

