/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.samlext.saml2mdui.PrivacyStatementURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePrivacyURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 1706444251504545781L;
    private static Logger log = LoggerFactory.getLogger(ServicePrivacyURLTag.class);
    private static String linkText;

    public void setLinkText(String text) {
        linkText = text;
    }

    private String getPrivacyURLFromUIIinfo() {
        if (this.getSPUIInfo() != null && this.getSPUIInfo().getPrivacyStatementURLs() != null) {
            List<String> languages = this.getBrowserLanguages();
            for (String lang : languages) {
                for (PrivacyStatementURL privacyURL : this.getSPUIInfo().getPrivacyStatementURLs()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Found PrivacyStatementURL in UIInfo, language=" + privacyURL.getXMLLang());
                    }
                    if (!privacyURL.getXMLLang().equals(lang)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("returning URL from UIInfo " + privacyURL.getURI().getLocalString());
                    }
                    return privacyURL.getURI().getLocalString();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("No relevant PrivacyStatementURL in UIInfo");
            }
        }
        return null;
    }

    public int doEndTag() throws JspException {
        String privacyURL = this.getPrivacyURLFromUIIinfo();
        try {
            if (null == privacyURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(privacyURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating Description");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

