/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session.impl;

import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import edu.internet2.middleware.shibboleth.idp.session.impl.SessionImpl;
import edu.internet2.middleware.shibboleth.idp.session.impl.SessionManagerEntry;
import java.security.SecureRandom;
import org.apache.commons.ssl.util.Hex;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SessionManagerImpl
implements SessionManager<Session> {
    private final Logger log = LoggerFactory.getLogger(SessionManagerImpl.class);
    private final int sessionIDSize = 32;
    private final SecureRandom prng = new SecureRandom();
    private StorageService<String, SessionManagerEntry> sessionStore;
    private String partition;
    private long sessionLifetime;

    public SessionManagerImpl(StorageService<String, SessionManagerEntry> storageService, long lifetime) {
        this.sessionStore = storageService;
        this.partition = "session";
        this.sessionLifetime = lifetime;
    }

    public SessionManagerImpl(StorageService<String, SessionManagerEntry> storageService, String storageParition, long lifetime) {
        this.sessionStore = storageService;
        this.partition = !DatatypeHelper.isEmpty((String)storageParition) ? DatatypeHelper.safeTrim((String)storageParition) : "session";
        this.sessionLifetime = lifetime;
    }

    public Session createSession() {
        byte[] sid = new byte[32];
        this.prng.nextBytes(sid);
        String sessionID = Hex.encode((byte[])sid);
        byte[] sessionSecret = new byte[16];
        this.prng.nextBytes(sessionSecret);
        SessionImpl session = new SessionImpl(sessionID, sessionSecret, this.sessionLifetime);
        SessionManagerEntry sessionEntry = new SessionManagerEntry(session, this.sessionLifetime);
        this.sessionStore.put(this.partition, (Object)sessionID, (Object)sessionEntry);
        MDC.put((String)"idpSessionId", (String)sessionID);
        this.log.trace("Created session {}", (Object)sessionID);
        return session;
    }

    public Session createSession(String principal) {
        byte[] sid = new byte[32];
        this.prng.nextBytes(sid);
        String sessionID = Hex.encode((byte[])sid);
        byte[] sessionSecret = new byte[16];
        this.prng.nextBytes(sessionSecret);
        SessionImpl session = new SessionImpl(sessionID, sessionSecret, this.sessionLifetime);
        SessionManagerEntry sessionEntry = new SessionManagerEntry(session, this.sessionLifetime);
        this.sessionStore.put(this.partition, (Object)sessionID, (Object)sessionEntry);
        MDC.put((String)"idpSessionId", (String)sessionID);
        this.log.trace("Created session {}", (Object)sessionID);
        return session;
    }

    public void destroySession(String sessionID) {
        if (sessionID == null) {
            return;
        }
        SessionManagerEntry sessionEntry = (SessionManagerEntry)((Object)this.sessionStore.get(this.partition, (Object)sessionID));
        if (sessionEntry == null) {
            return;
        }
        for (String sessionIndex : sessionEntry.getSessionIndexes()) {
            this.sessionStore.remove(this.partition, (Object)sessionIndex);
        }
        this.sessionStore.remove(this.partition, (Object)sessionID);
    }

    public Session getSession(String sessionID) {
        if (sessionID == null) {
            return null;
        }
        SessionManagerEntry sessionEntry = (SessionManagerEntry)((Object)this.sessionStore.get(this.partition, (Object)sessionID));
        if (sessionEntry == null) {
            return null;
        }
        if (sessionEntry.isExpired()) {
            this.destroySession(sessionEntry.getSessionId());
            return null;
        }
        return sessionEntry.getSession();
    }

    public boolean indexSession(Session session, String index) {
        if (this.sessionStore.contains(this.partition, (Object)index)) {
            return false;
        }
        SessionManagerEntry sessionEntry = (SessionManagerEntry)((Object)this.sessionStore.get(this.partition, (Object)session.getSessionID()));
        if (sessionEntry == null) {
            return false;
        }
        if (sessionEntry.getSessionIndexes().contains(index)) {
            return true;
        }
        sessionEntry.getSessionIndexes().add(index);
        this.sessionStore.put(this.partition, (Object)index, (Object)sessionEntry);
        this.log.trace("Added index {} to session {}", (Object)index, (Object)session.getSessionID());
        return true;
    }

    public void removeSessionIndex(String index) {
        SessionManagerEntry sessionEntry = (SessionManagerEntry)((Object)this.sessionStore.remove(this.partition, (Object)index));
        if (sessionEntry != null) {
            this.log.trace("Removing index {} for session {}", (Object)index, (Object)sessionEntry.getSessionId());
            sessionEntry.getSessionIndexes().remove(index);
        }
    }
}

