/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.profile.provider;

import edu.internet2.middleware.shibboleth.common.profile.provider.AbstractRequestURIMappedProfileHandler;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.SAMLMDRelyingPartyConfigurationManager;
import edu.internet2.middleware.shibboleth.common.session.Session;
import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import org.opensaml.Configuration;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.parse.ParserPool;

public abstract class AbstractShibbolethProfileHandler<RPManagerType extends SAMLMDRelyingPartyConfigurationManager, SessionType extends Session>
extends AbstractRequestURIMappedProfileHandler<HTTPInTransport, HTTPOutTransport> {
    private ParserPool parserPool;
    private StorageService<?, ?> storageService;
    private RPManagerType rpManager;
    private SessionManager<SessionType> sessionManager;
    private XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    protected AbstractShibbolethProfileHandler() {
    }

    public abstract String getProfileId();

    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(ParserPool pool) {
        this.parserPool = pool;
    }

    public StorageService<?, ?> getStorageService() {
        return this.storageService;
    }

    public void setStorageService(StorageService<?, ?> service) {
        this.storageService = service;
    }

    public RPManagerType getRelyingPartyConfigurationManager() {
        return this.rpManager;
    }

    public void setRelyingPartyConfigurationManager(RPManagerType manager) {
        this.rpManager = manager;
    }

    public RelyingPartyConfiguration getRelyingPartyConfiguration(String relyingPartyId) {
        RPManagerType rpcManager = this.getRelyingPartyConfigurationManager();
        if (rpcManager != null) {
            return rpcManager.getRelyingPartyConfiguration(relyingPartyId);
        }
        return null;
    }

    public ProfileConfiguration getProfileConfiguration(String relyingPartyId, String profileId) {
        RelyingPartyConfiguration rpConfig = this.getRelyingPartyConfiguration(relyingPartyId);
        if (rpConfig != null) {
            return rpConfig.getProfileConfigurations().get(profileId);
        }
        return null;
    }

    public SessionManager<SessionType> getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager<SessionType> manager) {
        this.sessionManager = manager;
    }

    public XMLObjectBuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }
}

