/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractCredentialFactoryBean;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.BasicCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCredentialFactoryBean
extends AbstractCredentialFactoryBean {
    private final Logger log = LoggerFactory.getLogger(BasicCredentialFactoryBean.class);
    private SecretKey secretKey;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    protected Object createInstance() throws Exception {
        BasicCredential credential = new BasicCredential();
        credential.setUsageType(this.getUsageType());
        credential.setEntityId(this.getEntityID());
        if (this.getKeyNames() != null) {
            credential.getKeyNames().addAll(this.getKeyNames());
        }
        credential.setSecretKey(this.secretKey);
        credential.setPrivateKey(this.privateKey);
        if (this.publicKey != null) {
            credential.setPublicKey(this.publicKey);
        } else if (this.privateKey != null) {
            credential.setPublicKey(SecurityHelper.derivePublicKey((PrivateKey)this.privateKey));
        }
        if (credential.getPublicKey() != null && credential.getPrivateKey() != null) {
            boolean matched = false;
            try {
                matched = SecurityHelper.matchKeyPair((PublicKey)credential.getPublicKey(), (PrivateKey)credential.getPrivateKey());
            }
            catch (SecurityException e) {
                this.log.warn("Could not perform sanity check against credential public and private key: {}", (Object)e.getMessage());
            }
            if (!matched) {
                this.log.error("Mismatch detected between credential's public and private key");
                throw new SecurityException("Mismatch between credential public and private key");
            }
        }
        return credential;
    }

    public Class getObjectType() {
        return BasicCredential.class;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setPrivateKey(PrivateKey key) {
        this.privateKey = key;
    }

    public void setPublicKey(PublicKey key) {
        this.publicKey = key;
    }

    public void setSecretKey(SecretKey key) {
        this.secretKey = key;
    }
}

