/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.relyingparty.saml;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.CryptoOperationRequirementLevel;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSAMLProfileConfigurationBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String secCredRef;
        builder.setLazyInit(true);
        Map children = XMLHelper.getChildElements((Element)element);
        List audienceElems = (List)children.get(new QName("urn:mace:shibboleth:2.0:relying-party:saml", "Audience"));
        if (audienceElems != null && audienceElems.size() > 0) {
            LazyList audiences = new LazyList();
            for (Element audienceElem : audienceElems) {
                audiences.add((Object)DatatypeHelper.safeTrimOrNullString((String)audienceElem.getTextContent()));
            }
            builder.addPropertyValue("audiences", (Object)audiences);
        }
        if ((secCredRef = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "signingCredentialRef"))) != null) {
            builder.addDependsOn(secCredRef);
            builder.addPropertyReference("signingCredential", secCredRef);
        }
        long lifetime = 300000L;
        if (element.hasAttributeNS(null, "assertionLifetime")) {
            lifetime = SpringConfigurationUtils.parseDurationToMillis("'assertionLifetime' on profile configuration of type " + XMLHelper.getXSIType((Element)element), element.getAttributeNS(null, "assertionLifetime"), 0);
        }
        builder.addPropertyValue("assertionLifetime", (Object)lifetime);
        String artifactType = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "outboundArtifactType"));
        if (artifactType != null) {
            byte[] artifactTypeBytes = DatatypeHelper.intToByteArray((int)Integer.parseInt(artifactType));
            byte[] trimmedArtifactTypeBytes = new byte[]{artifactTypeBytes[2], artifactTypeBytes[3]};
            builder.addPropertyValue("outboundArtifactType", (Object)trimmedArtifactTypeBytes);
        }
        CryptoOperationRequirementLevel signRequests = CryptoOperationRequirementLevel.conditional;
        if (element.hasAttributeNS(null, "signRequests")) {
            signRequests = CryptoOperationRequirementLevel.valueOf(element.getAttributeNS(null, "signRequests"));
        }
        builder.addPropertyValue("signRequests", (Object)signRequests);
        CryptoOperationRequirementLevel signResponses = this.getSignResponsesDefault();
        if (element.hasAttributeNS(null, "signResponses")) {
            signResponses = CryptoOperationRequirementLevel.valueOf(element.getAttributeNS(null, "signResponses"));
        }
        builder.addPropertyValue("signResponses", (Object)signResponses);
        CryptoOperationRequirementLevel signAssertions = this.getSignAssertionsDefault();
        if (element.hasAttributeNS(null, "signAssertions")) {
            signAssertions = CryptoOperationRequirementLevel.valueOf(element.getAttributeNS(null, "signAssertions"));
        }
        builder.addPropertyValue("signAssertions", (Object)signAssertions);
        String secPolRef = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "securityPolicyRef"));
        if (secPolRef != null) {
            builder.addDependsOn(secPolRef);
            builder.addPropertyReference("profileSecurityPolicy", secPolRef);
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected abstract CryptoOperationRequirementLevel getSignResponsesDefault();

    protected abstract CryptoOperationRequirementLevel getSignAssertionsDefault();
}

