/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import edu.internet2.middleware.shibboleth.common.util.StringResourceLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngine {
    private final Logger log = LoggerFactory.getLogger(TemplateEngine.class);
    private VelocityEngine velocity;

    public TemplateEngine(VelocityEngine engine) {
        this.velocity = engine;
    }

    public void registerTemplate(String templateName, String template) {
        StringResourceRepository repository = StringResourceLoader.getRepository();
        repository.putStringResource(templateName, template);
    }

    public String createStatement(String templateName, ShibbolethResolutionContext resolutionContext, List<String> dependencies, CharacterEscapingStrategy escapingStrategy) throws AttributeResolutionException {
        VelocityContext vContext = this.createVelocityContext(resolutionContext, dependencies, escapingStrategy);
        try {
            this.log.trace("Populating the following {} template", (Object)templateName);
            StringWriter output = new StringWriter();
            Template template = this.velocity.getTemplate(templateName);
            template.merge((Context)vContext, (Writer)output);
            return output.toString();
        }
        catch (Exception e) {
            this.log.error("Unable to populate " + templateName + " template", (Throwable)e);
            throw new AttributeResolutionException("Unable to evaluate template", e);
        }
    }

    protected VelocityContext createVelocityContext(ShibbolethResolutionContext resolutionContext, List<String> dependencies, CharacterEscapingStrategy escapingStrategy) throws AttributeResolutionException {
        this.log.trace("Populating velocity context");
        VelocityContext vCtx = new VelocityContext();
        vCtx.put("requestContext", (Object)resolutionContext.getAttributeRequestContext());
        for (String dependencyId : dependencies) {
            ResolutionPlugIn plugin = resolutionContext.getResolvedPlugins().get(dependencyId);
            if (plugin instanceof DataConnector) {
                this.log.trace("Resolving attributes from data connector {}", (Object)dependencyId);
                Map attributes = (Map)((DataConnector)plugin).resolve(resolutionContext);
                for (String attributeId : attributes.keySet()) {
                    vCtx.put(attributeId, this.prepareAttributeValues((BaseAttribute)attributes.get(attributeId), escapingStrategy));
                }
                continue;
            }
            if (plugin instanceof AttributeDefinition) {
                this.log.trace("Resolving attributes from attribute definition {}", (Object)dependencyId);
                BaseAttribute attribute = (BaseAttribute)((AttributeDefinition)plugin).resolve(resolutionContext);
                if (!vCtx.containsKey((Object)attribute.getId())) {
                    vCtx.put(attribute.getId(), new ArrayList());
                }
                ((List)vCtx.get(attribute.getId())).addAll(attribute.getValues());
                continue;
            }
            this.log.trace("Unable to locate resolution plugin {}", (Object)dependencyId);
        }
        return vCtx;
    }

    protected List<Object> prepareAttributeValues(BaseAttribute attribute, CharacterEscapingStrategy escapingStrategy) {
        ArrayList<Object> preparedValues = new ArrayList<Object>();
        if (attribute == null || attribute.getValues() == null || attribute.getValues().isEmpty()) {
            return preparedValues;
        }
        if (escapingStrategy == null) {
            preparedValues.addAll(attribute.getValues());
        } else {
            for (Object value : attribute.getValues()) {
                if (value instanceof String) {
                    preparedValues.add(escapingStrategy.escape(value.toString()));
                    continue;
                }
                preparedValues.add(value);
            }
        }
        return preparedValues;
    }

    public static interface CharacterEscapingStrategy {
        public String escape(String var1);
    }
}

