/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.util.DataSealer;
import edu.internet2.middleware.shibboleth.common.util.DataSealerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoTransientIdAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger log = LoggerFactory.getLogger(CryptoTransientIdAttributeDefinition.class);
    private DataSealer dataSealer;
    private long idLifetime;

    public CryptoTransientIdAttributeDefinition(DataSealer sealer) {
        if (sealer == null) {
            throw new IllegalArgumentException("DataSealer may not be null.");
        }
        this.dataSealer = sealer;
        this.idLifetime = 14400000L;
    }

    @Override
    protected BaseAttribute<String> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String transientId;
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        StringBuilder principalTokenIdBuilder = new StringBuilder();
        principalTokenIdBuilder.append(requestContext.getOutboundMessageIssuer()).append("!").append(requestContext.getInboundMessageIssuer()).append("!").append(requestContext.getPrincipalName());
        try {
            transientId = this.dataSealer.wrap(principalTokenIdBuilder.toString(), System.currentTimeMillis() + this.idLifetime);
        }
        catch (DataSealerException e) {
            throw new AttributeResolutionException("Caught exception wrapping principal identifier.", e);
        }
        BasicAttribute<String> attribute = new BasicAttribute<String>();
        attribute.setId(this.getId());
        attribute.getValues().add(transientId);
        return attribute;
    }

    public long getIdLifetime() {
        return this.idLifetime;
    }

    public void setIdLifetime(long lifetime) {
        this.idLifetime = lifetime;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.dataSealer == null) {
            log.error("CryptoTransientIdAttributeDefinition (" + this.getId() + ") must have a DataSealer object set.");
            throw new AttributeResolutionException("CryptoTransientIdAttributeDefinition (" + this.getId() + ") must have a DataSealer object set.");
        }
    }
}

