/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.security.BaseSAMLXMLSignatureSecurityPolicyRule;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLProtocolMessageXMLSignatureSecurityPolicyRule
extends BaseSAMLXMLSignatureSecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(SAMLProtocolMessageXMLSignatureSecurityPolicyRule.class);
    private Validator<Signature> sigValidator;

    public SAMLProtocolMessageXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
        super(engine);
        this.sigValidator = new SAMLSignatureProfileValidator();
    }

    public SAMLProtocolMessageXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine, Validator<Signature> signatureValidator) {
        super(engine);
        this.sigValidator = signatureValidator;
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.debug("Invalid message context type, this policy rule only supports SAMLMessageContext");
            return;
        }
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object samlMsg = samlMsgCtx.getInboundSAMLMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            this.log.debug("Extracted SAML message was not a SignableSAMLObject, can not process signature");
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            this.log.info("SAML protocol message was not signed, skipping XML signature processing");
            return;
        }
        Signature signature = signableObject.getSignature();
        this.performPreValidation(signature);
        this.doEvaluate(signature, signableObject, samlMsgCtx);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doEvaluate(Signature signature, SignableSAMLObject signableObject, SAMLMessageContext samlMsgCtx) throws SecurityPolicyException {
        String contextIssuer = samlMsgCtx.getInboundMessageIssuer();
        if (contextIssuer == null) {
            this.log.debug("Context issuer unavailable, can not attempt SAML protocol message signature validation");
            throw new SecurityPolicyException("Context issuer unavailable, can not validate signature");
        }
        String msgType = signableObject.getElementQName().toString();
        this.log.debug("Attempting to verify signature on signed SAML protocol message using context issuer message type: {}", (Object)msgType);
        if (this.evaluate(signature, contextIssuer, samlMsgCtx)) {
            this.log.info("Validation of protocol message signature succeeded, message type: {}", (Object)msgType);
            if (samlMsgCtx.isInboundSAMLMessageAuthenticated()) return;
            this.log.debug("Authentication via protocol message signature succeeded for context issuer entity ID {}", (Object)contextIssuer);
            samlMsgCtx.setInboundSAMLMessageAuthenticated(true);
            return;
        }
        this.log.debug("Validation of protocol message signature failed for context issuer '" + contextIssuer + "', message type: " + msgType);
        throw new SecurityPolicyException("Validation of protocol message signature failed");
    }

    protected Validator<Signature> getSignaturePrevalidator() {
        return this.sigValidator;
    }

    protected void performPreValidation(Signature signature) throws SecurityPolicyException {
        if (this.getSignaturePrevalidator() != null) {
            try {
                this.getSignaturePrevalidator().validate((XMLObject)signature);
            }
            catch (ValidationException e) {
                this.log.debug("Protocol message signature failed signature pre-validation", (Throwable)e);
                throw new SecurityPolicyException("Protocol message signature failed signature pre-validation", (Exception)((Object)e));
            }
        }
    }
}

