/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.opensaml.xml.util.DatatypeHelper;

public class HttpResource
extends AbstractFilteredResource {
    private String resourceUrl;
    private HttpClient httpClient;

    public HttpResource(String resource) {
        this.resourceUrl = DatatypeHelper.safeTrimOrNullString((String)resource);
        if (this.resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL may not be null or empty");
        }
        this.httpClient = new HttpClient();
    }

    public HttpResource(String resource, ResourceFilter resourceFilter) {
        super(resourceFilter);
        this.resourceUrl = DatatypeHelper.safeTrimOrNullString((String)resource);
        if (this.resourceUrl == null) {
            throw new IllegalArgumentException("Resource URL may not be null or empty");
        }
        this.httpClient = new HttpClient();
    }

    @Override
    public boolean exists() throws ResourceException {
        HeadMethod headMethod = new HeadMethod(this.resourceUrl);
        try {
            this.httpClient.executeMethod((HttpMethod)headMethod);
            return headMethod.getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new ResourceException("Unable to contact resource URL: " + this.resourceUrl, e);
        }
    }

    @Override
    public InputStream getInputStream() throws ResourceException {
        GetMethod getMethod = this.getResource();
        try {
            return this.applyFilter(getMethod.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw new ResourceException("Unable to read response", e);
        }
    }

    @Override
    public DateTime getLastModifiedTime() throws ResourceException {
        HeadMethod headMethod = new HeadMethod(this.resourceUrl);
        try {
            this.httpClient.executeMethod((HttpMethod)headMethod);
            if (headMethod.getStatusCode() != 200) {
                throw new ResourceException("Unable to retrieve resource URL " + this.resourceUrl + ", received HTTP status code " + headMethod.getStatusCode());
            }
            Header lastModifiedHeader = headMethod.getResponseHeader("Last-Modified");
            if (lastModifiedHeader != null && !DatatypeHelper.isEmpty((String)lastModifiedHeader.getValue())) {
                long lastModifiedTime = DateUtil.parseDate((String)lastModifiedHeader.getValue()).getTime();
                return new DateTime(lastModifiedTime, (Chronology)ISOChronology.getInstanceUTC());
            }
            return new DateTime();
        }
        catch (IOException e) {
            throw new ResourceException("Unable to contact resource URL: " + this.resourceUrl, e);
        }
        catch (DateParseException e) {
            throw new ResourceException("Unable to parse last modified date for resource:" + this.resourceUrl, (Exception)((Object)e));
        }
    }

    @Override
    public String getLocation() {
        return this.resourceUrl;
    }

    public String toString() {
        return this.getLocation();
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpResource) {
            return this.getLocation().equals(((HttpResource)o).getLocation());
        }
        return false;
    }

    protected GetMethod getResource() throws ResourceException {
        GetMethod getMethod = new GetMethod(this.resourceUrl);
        try {
            this.httpClient.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() != 200) {
                throw new ResourceException("Unable to retrieve resource URL " + this.resourceUrl + ", received HTTP status code " + getMethod.getStatusCode());
            }
            return getMethod;
        }
        catch (IOException e) {
            throw new ResourceException("Unable to contact resource URL: " + this.resourceUrl, e);
        }
    }
}

