/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.profile.saml2;

import edu.internet2.middleware.shibboleth.common.profile.ProfileException;
import edu.internet2.middleware.shibboleth.common.profile.provider.BaseSAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.RelyingPartyConfiguration;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml2.SSOConfiguration;
import edu.internet2.middleware.shibboleth.common.util.HttpHelper;
import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.PassiveAuthenticationException;
import edu.internet2.middleware.shibboleth.idp.authn.Saml2LoginContext;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.AbstractSAML2ProfileHandler;
import edu.internet2.middleware.shibboleth.idp.profile.saml2.BaseSAML2ProfileRequestContext;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.saml2.binding.AuthnResponseEndpointSelector;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.SubjectLocality;
import org.opensaml.saml2.metadata.AffiliateMember;
import org.opensaml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SSOProfileHandler
extends AbstractSAML2ProfileHandler {
    private final Logger log = LoggerFactory.getLogger(SSOProfileHandler.class);
    private SAMLObjectBuilder<AuthnStatement> authnStatementBuilder;
    private SAMLObjectBuilder<AuthnContext> authnContextBuilder;
    private SAMLObjectBuilder<AuthnContextClassRef> authnContextClassRefBuilder;
    private SAMLObjectBuilder<AuthnContextDeclRef> authnContextDeclRefBuilder;
    private SAMLObjectBuilder<SubjectLocality> subjectLocalityBuilder;
    private SAMLObjectBuilder<Endpoint> endpointBuilder;
    private String authenticationManagerPath;

    public SSOProfileHandler(String authnManagerPath) {
        if (DatatypeHelper.isEmpty((String)authnManagerPath)) {
            throw new IllegalArgumentException("Authentication manager path may not be null");
        }
        this.authenticationManagerPath = authnManagerPath.startsWith("/") ? authnManagerPath : "/" + authnManagerPath;
        this.authnStatementBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
        this.authnContextBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
        this.authnContextClassRefBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        this.authnContextDeclRefBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AuthnContextDeclRef.DEFAULT_ELEMENT_NAME);
        this.subjectLocalityBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(SubjectLocality.DEFAULT_ELEMENT_NAME);
        this.endpointBuilder = (SAMLObjectBuilder)this.getBuilderFactory().getBuilder(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
    }

    public String getProfileId() {
        return "urn:mace:shibboleth:2.0:profiles:saml2:sso";
    }

    public void processRequest(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)outTransport).getWrappedResponse();
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        LoginContext loginContext = HttpServletHelper.getLoginContext(this.getStorageService(), servletContext, httpRequest);
        if (loginContext == null || !(loginContext instanceof Saml2LoginContext)) {
            this.log.debug("Incoming request does not contain a login context, processing as first leg of request");
            this.performAuthentication(inTransport, outTransport);
        } else if (loginContext.isPrincipalAuthenticated() || loginContext.getAuthenticationFailure() != null) {
            this.log.debug("Incoming request contains a login context, processing as second leg of request");
            HttpServletHelper.unbindLoginContext(this.getStorageService(), servletContext, httpRequest, httpResponse);
            this.completeAuthenticationRequest((Saml2LoginContext)loginContext, inTransport, outTransport);
        } else {
            this.log.debug("Incoming request contained a login context but principal was not authenticated, processing as first leg of request");
            this.performAuthentication(inTransport, outTransport);
        }
    }

    protected void performAuthentication(HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        HttpServletRequest httpRequest = ((HttpServletRequestAdapter)inTransport).getWrappedRequest();
        HttpServletResponse httpResponse = ((HttpServletResponseAdapter)outTransport).getWrappedResponse();
        SSORequestContext requestContext = new SSORequestContext();
        try {
            this.decodeRequest(requestContext, inTransport, outTransport);
            String relyingPartyId = requestContext.getInboundMessageIssuer();
            requestContext.setPeerEntityId(relyingPartyId);
            RelyingPartyConfiguration rpConfig = this.getRelyingPartyConfiguration(relyingPartyId);
            ProfileConfiguration ssoConfig = rpConfig.getProfileConfiguration(this.getProfileId());
            if (ssoConfig == null) {
                String msg = "SAML 2 SSO profile is not configured for relying party " + requestContext.getInboundMessageIssuer();
                this.log.warn(msg);
                throw new ProfileException(msg);
            }
            this.log.debug("Creating login context and transferring control to authentication engine");
            Saml2LoginContext loginContext = new Saml2LoginContext(relyingPartyId, requestContext.getRelayState(), (AuthnRequest)requestContext.getInboundSAMLMessage());
            loginContext.setUnsolicited(requestContext.isUnsolicited());
            loginContext.setAuthenticationEngineURL(this.authenticationManagerPath);
            loginContext.setProfileHandlerURL(HttpHelper.getRequestUriWithoutContext((HttpServletRequest)httpRequest));
            loginContext.setDefaultAuthenticationMethod(rpConfig.getDefaultAuthenticationMethod());
            HttpServletHelper.bindLoginContext(loginContext, this.getStorageService(), httpRequest.getSession().getServletContext(), httpRequest, httpResponse);
            String authnEngineUrl = HttpServletHelper.getContextRelativeUrl(httpRequest, this.authenticationManagerPath).buildURL();
            this.log.debug("Redirecting user to authentication engine at {}", (Object)authnEngineUrl);
            httpResponse.sendRedirect(authnEngineUrl);
        }
        catch (MarshallingException e) {
            this.log.error("Unable to marshall authentication request context");
            throw new ProfileException("Unable to marshall authentication request context", (Throwable)e);
        }
        catch (IOException ex) {
            this.log.error("Error forwarding SAML 2 AuthnRequest to AuthenticationManager", (Throwable)ex);
            throw new ProfileException("Error forwarding SAML 2 AuthnRequest to AuthenticationManager", (Throwable)ex);
        }
    }

    protected void completeAuthenticationRequest(Saml2LoginContext loginContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        Response samlResponse;
        SSORequestContext requestContext = this.buildRequestContext(loginContext, inTransport, outTransport);
        try {
            AttributeStatement attributeStatement;
            this.checkSamlVersion(requestContext);
            this.checkNameIDPolicy(requestContext);
            if (loginContext.getAuthenticationFailure() != null) {
                if (loginContext.getAuthenticationFailure() instanceof PassiveAuthenticationException) {
                    requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:NoPassive", null));
                } else {
                    requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", null));
                }
                throw new ProfileException("Authentication failure", (Throwable)loginContext.getAuthenticationFailure());
            }
            if (requestContext.getSubjectNameIdentifier() != null) {
                this.log.debug("Authentication request contained a subject with a name identifier, resolving principal from NameID");
                this.resolvePrincipal(requestContext);
                String requestedPrincipalName = requestContext.getPrincipalName();
                if (!DatatypeHelper.safeEquals((Object)loginContext.getPrincipalName(), (Object)requestedPrincipalName)) {
                    this.log.warn("Authentication request identified principal {} but authentication mechanism identified principal {}", (Object)requestedPrincipalName, (Object)loginContext.getPrincipalName());
                    requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", null));
                    throw new ProfileException("User failed authentication");
                }
            }
            this.resolveAttributes(requestContext);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            statements.add((Statement)this.buildAuthnStatement(requestContext));
            if (((SSOConfiguration)requestContext.getProfileConfiguration()).includeAttributeStatement() && (attributeStatement = this.buildAttributeStatement(requestContext)) != null) {
                requestContext.setReleasedAttributes(requestContext.getAttributes().keySet());
                statements.add((Statement)attributeStatement);
            }
            samlResponse = this.buildResponse(requestContext, "urn:oasis:names:tc:SAML:2.0:cm:bearer", statements);
        }
        catch (ProfileException e) {
            if (requestContext.isUnsolicited()) {
                this.log.warn("Unsolicited response generation failed: {}", (Object)e.getMessage());
                throw e;
            }
            samlResponse = this.buildErrorResponse(requestContext);
        }
        requestContext.setOutboundSAMLMessage((SAMLObject)samlResponse);
        requestContext.setOutboundSAMLMessageId(samlResponse.getID());
        requestContext.setOutboundSAMLMessageIssueInstant(samlResponse.getIssueInstant());
        this.encodeResponse(requestContext);
        this.writeAuditLogEntry(requestContext);
    }

    protected void decodeRequest(SSORequestContext requestContext, HTTPInTransport inTransport, HTTPOutTransport outTransport) throws ProfileException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Decoding message with decoder binding '{}'", (Object)this.getInboundMessageDecoder(requestContext).getBindingURI());
        }
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMetadataProvider(this.getMetadataProvider());
        requestContext.setSecurityPolicyResolver(this.getSecurityPolicyResolver());
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setInboundMessageTransport((InTransport)inTransport);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        requestContext.setOutboundMessageTransport((OutTransport)outTransport);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        try {
            SAMLMessageDecoder decoder = this.getInboundMessageDecoder(requestContext);
            requestContext.setMessageDecoder(decoder);
            decoder.decode((MessageContext)requestContext);
            this.log.debug("Decoded request from relying party '{}'", (Object)requestContext.getInboundMessageIssuer());
            if (!(requestContext.getInboundSAMLMessage() instanceof AuthnRequest)) {
                this.log.warn("Incomming message was not a AuthnRequest, it was a '{}'", (Object)((AuthnRequest)requestContext.getInboundSAMLMessage()).getClass().getName());
                requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", null, "Invalid SAML AuthnRequest message."));
                throw new ProfileException("Invalid SAML AuthnRequest message.");
            }
        }
        catch (MessageDecodingException e) {
            String msg = "Error decoding authentication request message";
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
        catch (SecurityException e) {
            String msg = "Message did not meet security requirements";
            this.log.warn(msg, (Throwable)e);
            throw new ProfileException(msg, (Throwable)e);
        }
    }

    protected void checkNameIDPolicy(SSORequestContext requestContext) throws ProfileException {
        AuthnRequest request = (AuthnRequest)requestContext.getInboundSAMLMessage();
        NameIDPolicy nameIdPolcy = request.getNameIDPolicy();
        if (nameIdPolcy == null) {
            return;
        }
        String spNameQualifier = DatatypeHelper.safeTrimOrNullString((String)nameIdPolcy.getSPNameQualifier());
        if (spNameQualifier == null) {
            return;
        }
        if (DatatypeHelper.safeEquals((Object)spNameQualifier, (Object)requestContext.getInboundMessageIssuer())) {
            this.log.debug("SPNameQualifier '{}' matches message issuer.", (Object)spNameQualifier);
            return;
        }
        this.log.debug("Checking if message issuer is a member of affiliation '{}'", (Object)spNameQualifier);
        try {
            AffiliationDescriptor affiliationDescriptor;
            EntityDescriptor affiliation = this.getMetadataProvider().getEntityDescriptor(spNameQualifier);
            if (affiliation != null && (affiliationDescriptor = affiliation.getAffiliationDescriptor()) != null && affiliationDescriptor.getMembers() != null) {
                for (AffiliateMember member : affiliationDescriptor.getMembers()) {
                    if (!DatatypeHelper.safeEquals((Object)member.getID(), (Object)requestContext.getInboundMessageIssuer())) continue;
                    return;
                }
            }
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Invalid SPNameQualifier for this request"));
            throw new ProfileException("Relying party '" + requestContext.getInboundMessageIssuer() + "' is not a member of the affiliation " + spNameQualifier);
        }
        catch (MetadataProviderException e) {
            requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Internal service error"));
            this.log.error("Error looking up metadata for affiliation", (Throwable)e);
            throw new ProfileException("Relying party '" + requestContext.getInboundMessageIssuer() + "' is not a member of the affiliation " + spNameQualifier);
        }
    }

    protected SSORequestContext buildRequestContext(Saml2LoginContext loginContext, HTTPInTransport in, HTTPOutTransport out) throws ProfileException {
        SSORequestContext requestContext = new SSORequestContext();
        requestContext.setCommunicationProfileId(this.getProfileId());
        requestContext.setMessageDecoder(this.getInboundMessageDecoder(requestContext));
        requestContext.setLoginContext(loginContext);
        requestContext.setUnsolicited(loginContext.isUnsolicited());
        requestContext.setInboundMessageTransport((InTransport)in);
        requestContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setOutboundMessageTransport((OutTransport)out);
        requestContext.setOutboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        requestContext.setMetadataProvider(this.getMetadataProvider());
        String relyingPartyId = loginContext.getRelyingPartyId();
        requestContext.setPeerEntityId(relyingPartyId);
        requestContext.setInboundMessageIssuer(relyingPartyId);
        this.populateRequestContext(requestContext);
        return requestContext;
    }

    @Override
    protected void populateRelyingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateRelyingPartyInformation(requestContext);
        EntityDescriptor relyingPartyMetadata = requestContext.getPeerEntityMetadata();
        if (relyingPartyMetadata != null) {
            requestContext.setPeerEntityRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setPeerEntityRoleMetadata((RoleDescriptor)relyingPartyMetadata.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected void populateAssertingPartyInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        super.populateAssertingPartyInformation(requestContext);
        EntityDescriptor localEntityDescriptor = requestContext.getLocalEntityMetadata();
        if (localEntityDescriptor != null) {
            requestContext.setLocalEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            requestContext.setLocalEntityRoleMetadata((RoleDescriptor)localEntityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol"));
        }
    }

    @Override
    protected void populateSAMLMessageInformation(BaseSAMLProfileRequestContext requestContext) throws ProfileException {
        SSORequestContext ssoRequestContext = (SSORequestContext)requestContext;
        try {
            Saml2LoginContext loginContext = ssoRequestContext.getLoginContext();
            requestContext.setRelayState(loginContext.getRelayState());
            AuthnRequest authnRequest = this.deserializeRequest(loginContext.getAuthenticationRequest());
            requestContext.setInboundMessage((XMLObject)authnRequest);
            requestContext.setInboundSAMLMessage((SAMLObject)authnRequest);
            requestContext.setInboundSAMLMessageId(authnRequest.getID());
            Subject authnSubject = authnRequest.getSubject();
            if (authnSubject != null) {
                requestContext.setSubjectNameIdentifier((SAMLObject)authnSubject.getNameID());
            }
        }
        catch (UnmarshallingException e) {
            this.log.error("Unable to unmarshall authentication request context");
            ssoRequestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", null, "Error recovering request state"));
            throw new ProfileException("Error recovering request state", (Throwable)e);
        }
    }

    protected AuthnStatement buildAuthnStatement(SSORequestContext requestContext) {
        long maxSPSessionLifetime;
        Saml2LoginContext loginContext = requestContext.getLoginContext();
        AuthnContext authnContext = this.buildAuthnContext(requestContext);
        AuthnStatement statement = (AuthnStatement)this.authnStatementBuilder.buildObject();
        statement.setAuthnContext(authnContext);
        statement.setAuthnInstant(loginContext != null ? loginContext.getAuthenticationInstant() : null);
        Session session = this.getUserSession(requestContext.getInboundMessageTransport());
        if (session != null) {
            statement.setSessionIndex(session.getSessionID());
        }
        if ((maxSPSessionLifetime = ((SSOConfiguration)requestContext.getProfileConfiguration()).getMaximumSPSessionLifetime()) > 0L) {
            DateTime lifetime = new DateTime(DateTimeZone.UTC).plus(maxSPSessionLifetime);
            this.log.debug("Explicitly setting SP session expiration time to '{}'", (Object)lifetime.toString());
            statement.setSessionNotOnOrAfter(lifetime);
        }
        statement.setSubjectLocality(this.buildSubjectLocality(requestContext));
        return statement;
    }

    protected AuthnContext buildAuthnContext(SSORequestContext requestContext) {
        AuthnContext authnContext = (AuthnContext)this.authnContextBuilder.buildObject();
        Saml2LoginContext loginContext = requestContext.getLoginContext();
        AuthnRequest authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage();
        RequestedAuthnContext requestedAuthnContext = authnRequest.getRequestedAuthnContext();
        if (requestedAuthnContext != null) {
            if (requestedAuthnContext.getAuthnContextClassRefs() != null) {
                for (AuthnContextClassRef classRef : requestedAuthnContext.getAuthnContextClassRefs()) {
                    if (!DatatypeHelper.safeEquals((Object)classRef.getAuthnContextClassRef(), (Object)loginContext.getAuthenticationMethod())) continue;
                    AuthnContextClassRef ref = (AuthnContextClassRef)this.authnContextClassRefBuilder.buildObject();
                    ref.setAuthnContextClassRef(loginContext.getAuthenticationMethod());
                    authnContext.setAuthnContextClassRef(ref);
                }
            } else if (requestedAuthnContext.getAuthnContextDeclRefs() != null) {
                for (AuthnContextDeclRef declRef : requestedAuthnContext.getAuthnContextDeclRefs()) {
                    if (!DatatypeHelper.safeEquals((Object)declRef.getAuthnContextDeclRef(), (Object)loginContext.getAuthenticationMethod())) continue;
                    AuthnContextDeclRef ref = (AuthnContextDeclRef)this.authnContextDeclRefBuilder.buildObject();
                    ref.setAuthnContextDeclRef(loginContext.getAuthenticationMethod());
                    authnContext.setAuthnContextDeclRef(ref);
                }
            }
        }
        if (authnContext.getAuthnContextClassRef() == null || authnContext.getAuthnContextDeclRef() == null) {
            AuthnContextClassRef ref = (AuthnContextClassRef)this.authnContextClassRefBuilder.buildObject();
            ref.setAuthnContextClassRef(loginContext.getAuthenticationMethod());
            authnContext.setAuthnContextClassRef(ref);
        }
        return authnContext;
    }

    protected SubjectLocality buildSubjectLocality(SSORequestContext requestContext) {
        HTTPInTransport transport = (HTTPInTransport)requestContext.getInboundMessageTransport();
        SubjectLocality subjectLocality = (SubjectLocality)this.subjectLocalityBuilder.buildObject();
        subjectLocality.setAddress(transport.getPeerAddress());
        return subjectLocality;
    }

    @Override
    protected String getRequiredNameIDFormat(BaseSAMLProfileRequestContext requestContext) {
        String requiredNameFormat = null;
        AuthnRequest authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage();
        NameIDPolicy nameIdPolicy = authnRequest.getNameIDPolicy();
        if (nameIdPolicy != null && (requiredNameFormat = DatatypeHelper.safeTrimOrNullString((String)nameIdPolicy.getFormat())) != null && ("urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(requiredNameFormat) || "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(requiredNameFormat))) {
            requiredNameFormat = null;
        }
        return requiredNameFormat;
    }

    @Override
    protected NameID buildNameId(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext) throws ProfileException {
        AuthnRequest authnRequest;
        NameIDPolicy nameIdPolicy;
        NameID nameId = super.buildNameId(requestContext);
        if (nameId != null && (nameIdPolicy = (authnRequest = (AuthnRequest)requestContext.getInboundSAMLMessage()).getNameIDPolicy()) != null) {
            String spNameQualifier = DatatypeHelper.safeTrimOrNullString((String)nameIdPolicy.getSPNameQualifier());
            if (spNameQualifier != null) {
                if (nameId.getSPNameQualifier() != null) {
                    if (!nameId.getSPNameQualifier().equals(spNameQualifier)) {
                        requestContext.setFailureStatus(this.buildStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "Invalid SPNameQualifier for this request"));
                        throw new ProfileException("Requested SPNameQualifier '{" + spNameQualifier + "}' conflicts with generated value '{" + nameId.getSPNameQualifier() + "}'");
                    }
                } else {
                    nameId.setSPNameQualifier(spNameQualifier);
                }
            } else {
                nameId.setSPNameQualifier(requestContext.getInboundMessageIssuer());
            }
        }
        return nameId;
    }

    @Override
    protected Endpoint selectEndpoint(BaseSAMLProfileRequestContext requestContext) {
        AuthnRequest authnRequest = (AuthnRequest)((SSORequestContext)requestContext).getInboundSAMLMessage();
        Endpoint endpoint = null;
        if (requestContext.getRelyingPartyConfiguration().getRelyingPartyId() == "anonymous") {
            if (authnRequest.getAssertionConsumerServiceURL() != null) {
                endpoint = (Endpoint)this.endpointBuilder.buildObject();
                endpoint.setLocation(authnRequest.getAssertionConsumerServiceURL());
                if (authnRequest.getProtocolBinding() != null) {
                    endpoint.setBinding(authnRequest.getProtocolBinding());
                } else {
                    endpoint.setBinding(this.getSupportedOutboundBindings().get(0));
                }
                this.log.warn("Generating endpoint for anonymous relying party self-identified as '{}', ACS url '{}' and binding '{}'", new Object[]{requestContext.getInboundMessageIssuer(), endpoint.getLocation(), endpoint.getBinding()});
            } else {
                this.log.warn("Unable to generate endpoint for anonymous party.  No ACS URL provided.");
            }
        } else {
            AuthnResponseEndpointSelector endpointSelector = new AuthnResponseEndpointSelector();
            endpointSelector.setEndpointType(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
            endpointSelector.setMetadataProvider(this.getMetadataProvider());
            endpointSelector.setEntityMetadata(requestContext.getPeerEntityMetadata());
            endpointSelector.setEntityRoleMetadata(requestContext.getPeerEntityRoleMetadata());
            endpointSelector.setSamlRequest(requestContext.getInboundSAMLMessage());
            endpointSelector.getSupportedIssuerBindings().addAll(this.getSupportedOutboundBindings());
            endpoint = endpointSelector.selectEndpoint();
        }
        return endpoint;
    }

    protected AuthnRequest deserializeRequest(String request) throws UnmarshallingException {
        try {
            Element requestElem = this.getParserPool().parse((Reader)new StringReader(request)).getDocumentElement();
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(requestElem);
            return (AuthnRequest)unmarshaller.unmarshall(requestElem);
        }
        catch (Exception e) {
            throw new UnmarshallingException("Unable to read serialized authentication request");
        }
    }

    @Override
    protected void postProcessAssertion(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, Assertion assertion) throws ProfileException {
        Subject subject;
        SSORequestContext ctx = (SSORequestContext)requestContext;
        if (ctx.isUnsolicited() && (subject = assertion.getSubject()) != null) {
            for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                SubjectConfirmationData scd;
                if (sc == null || (scd = sc.getSubjectConfirmationData()) == null) continue;
                scd.setInResponseTo(null);
            }
        }
    }

    @Override
    protected void postProcessResponse(BaseSAML2ProfileRequestContext<?, ?, ?> requestContext, Response samlResponse) throws ProfileException {
        SSORequestContext ctx = (SSORequestContext)requestContext;
        if (ctx.isUnsolicited()) {
            samlResponse.setInResponseTo(null);
        }
    }

    protected class SSORequestContext
    extends BaseSAML2ProfileRequestContext<AuthnRequest, Response, SSOConfiguration> {
        private boolean unsolicited;
        private Saml2LoginContext loginContext;

        protected SSORequestContext() {
        }

        public boolean isUnsolicited() {
            return this.unsolicited;
        }

        public Saml2LoginContext getLoginContext() {
            return this.loginContext;
        }

        public void setUnsolicited(boolean unsolicited) {
            this.unsolicited = unsolicited;
        }

        public void setLoginContext(Saml2LoginContext context) {
            this.loginContext = context;
        }
    }
}

