/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2AttributeQueryTestCase
extends BaseConf1TestCase {
    public void testAttributeQuery() throws Exception {
        AttributeQuery query = this.buildAttributeQuery("urn:example.org:sp1");
        String soapMessage = this.getSOAPMessage(query);
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml2/SOAP/AttributeQuery");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2AttributeQueryTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML2AttributeQueryTestCase.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:Success"));
        SAML2AttributeQueryTestCase.assertTrue((boolean)response.contains(" Name=\"urn:oid:1.3.6.1.4.1.5923.1.1.1.7\""));
        SAML2AttributeQueryTestCase.assertTrue((boolean)response.contains("urn:example.org:entitlement:entitlement1"));
    }

    public void testAuthenticationWithoutConfiguredQuery() throws Exception {
        AttributeQuery query = this.buildAttributeQuery("urn:example.org:BogusSP");
        String soapMessage = this.getSOAPMessage(query);
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml2/SOAP/AttributeQuery");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML2AttributeQueryTestCase.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML2AttributeQueryTestCase.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:Responder"));
        SAML2AttributeQueryTestCase.assertTrue((boolean)response.contains("urn:oasis:names:tc:SAML:2.0:status:RequestDenied"));
    }

    protected AttributeQuery buildAttributeQuery(String requester) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(requester);
        SAMLObjectBuilder nameIdBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameId = (NameID)nameIdBuilder.buildObject();
        nameId.setValue("testUser");
        nameId.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        SAMLObjectBuilder subjectBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)subjectBuilder.buildObject();
        subject.setNameID(nameId);
        SAMLObjectBuilder attributeQueryBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AttributeQuery.DEFAULT_ELEMENT_NAME);
        AttributeQuery query = (AttributeQuery)attributeQueryBuilder.buildObject();
        query.setID("1");
        query.setIssueInstant(new DateTime());
        query.setIssuer(issuer);
        query.setSubject(subject);
        query.setVersion(SAMLVersion.VERSION_20);
        return query;
    }

    protected String getSOAPMessage(AttributeQuery query) throws MarshallingException {
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(query);
        SOAPObjectBuilder envelopeBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envelopeBuilder.buildObject();
        envelope.setBody(body);
        Marshaller marshaller = this.marshallerFactory.getMarshaller((XMLObject)envelope);
        Element envelopeElem = marshaller.marshall((XMLObject)envelope);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)envelopeElem, (Writer)writer);
        return writer.toString();
    }
}

