/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.system.conf1;

import edu.internet2.middleware.shibboleth.common.profile.ProfileHandler;
import edu.internet2.middleware.shibboleth.common.profile.ProfileHandlerManager;
import edu.internet2.middleware.shibboleth.idp.system.conf1.BaseConf1TestCase;
import java.io.StringWriter;
import java.io.Writer;
import java.security.SecureRandom;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.AssertionArtifact;
import org.opensaml.saml1.core.Request;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML1ArtifactResolutionTest
extends BaseConf1TestCase {
    public void testArtifactResolution() throws Exception {
        String relyingPartyId = "urn:example.org:sp1";
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.stageArtifact(relyingPartyId);
        String soapMessage = this.buildRequestMessage(relyingPartyId, artifactEntry.getArtifact());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml1/SOAP/ArtifactResolution");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML1ArtifactResolutionTest.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML1ArtifactResolutionTest.assertTrue((boolean)response.contains("saml1p:Success"));
        SAML1ArtifactResolutionTest.assertTrue((boolean)response.contains("saml1:Assertion"));
    }

    public void testWithoutConfiguration() throws Exception {
        String relyingPartyId = "urn:example.org:BogusSP";
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.stageArtifact(relyingPartyId);
        String soapMessage = this.buildRequestMessage(relyingPartyId, artifactEntry.getArtifact());
        MockHttpServletRequest servletRequest = new MockHttpServletRequest();
        servletRequest.setMethod("POST");
        servletRequest.setPathInfo("/saml1/SOAP/ArtifactResolution");
        servletRequest.setContent(soapMessage.getBytes());
        MockHttpServletResponse servletResponse = new MockHttpServletResponse();
        ProfileHandlerManager handlerManager = (ProfileHandlerManager)this.getApplicationContext().getBean("shibboleth.HandlerManager");
        ProfileHandler handler = handlerManager.getProfileHandler((ServletRequest)servletRequest);
        SAML1ArtifactResolutionTest.assertNotNull((Object)handler);
        HttpServletRequestAdapter profileRequest = new HttpServletRequestAdapter((HttpServletRequest)servletRequest);
        HttpServletResponseAdapter profileResponse = new HttpServletResponseAdapter((HttpServletResponse)servletResponse, false);
        handler.processRequest((InTransport)profileRequest, (OutTransport)profileResponse);
        String response = servletResponse.getContentAsString();
        SAML1ArtifactResolutionTest.assertTrue((boolean)response.contains("saml1p:Success"));
        SAML1ArtifactResolutionTest.assertTrue((boolean)response.contains("saml1p:RequestDenied"));
    }

    protected SAMLArtifactMap.SAMLArtifactMapEntry stageArtifact(String relyingPartyId) throws Exception {
        SAMLObjectBuilder assetionBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)assetionBuilder.buildObject();
        SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
        byte[] assertionHandle = new byte[20];
        handleGenerator.nextBytes(assertionHandle);
        SAML1ArtifactType0002 artifact = new SAML1ArtifactType0002(assertionHandle, relyingPartyId);
        SAMLArtifactMap artifactMap = (SAMLArtifactMap)this.getApplicationContext().getBean("shibboleth.ArtifactMap");
        artifactMap.put(artifact.base64Encode(), relyingPartyId, "urn:example.org:idp1", (SAMLObject)assertion);
        return artifactMap.get(artifact.base64Encode());
    }

    protected String buildRequestMessage(String relyingPartyId, String artifact) throws Exception {
        SAMLObjectBuilder assertionArtifactBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AssertionArtifact.DEFAULT_ELEMENT_NAME);
        AssertionArtifact aa = (AssertionArtifact)assertionArtifactBuilder.buildObject();
        aa.setAssertionArtifact(artifact);
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Request.DEFAULT_ELEMENT_NAME);
        Request request = (Request)requestBuilder.buildObject();
        request.setID("1");
        request.setIssueInstant(new DateTime());
        request.getAssertionArtifacts().add(aa);
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(request);
        SOAPObjectBuilder envelopeBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envelopeBuilder.buildObject();
        envelope.setBody(body);
        Marshaller marshaller = this.marshallerFactory.getMarshaller((XMLObject)envelope);
        Element envelopeElem = marshaller.marshall((XMLObject)envelope);
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode((Node)envelopeElem, (Writer)writer);
        return writer.toString();
    }
}

