/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.enumerator.Enumerator;

public class Parser {
    private final Scanner scanner;
    private static final short[] MUTUALS = new short[]{7};
    private WarningHandler optionalWarningHandler = null;

    public Parser(Scanner scanner) {
        this.scanner = scanner;
    }

    public void eatToken() throws Scanner.ScanException, IOException {
        this.scanner.read();
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    private static String join(String[] stringArray, String string) {
        if (stringArray == null) {
            return "(null)";
        }
        if (stringArray.length == 0) {
            return "(zero length array)";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string).append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Location location() {
        return this.scanner.location();
    }

    public Java.Atom parseAdditiveExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseMultiplicativeExpression();
        while (this.peekOperator(new String[]{"+", "-"})) {
            atom = new Java.BinaryOperation(this.location(), atom.toRvalueOrPE(), this.readOperator(), this.parseMultiplicativeExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseAndExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseEqualityExpression();
        while (this.peekOperator("&")) {
            Location location = this.location();
            this.eatToken();
            atom = new Java.BinaryOperation(location, atom.toRvalueOrPE(), "&", this.parseEqualityExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Rvalue[] parseArgumentList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        while (true) {
            arrayList.add(this.parseExpression().toRvalueOrPE());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Rvalue[] parseArguments() throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("(");
        if (this.peekOperator(")")) {
            this.eatToken();
            return new Java.Rvalue[0];
        }
        Java.Rvalue[] rvalueArray = this.parseArgumentList();
        this.readOperator(")");
        return rvalueArray;
    }

    public Java.ArrayInitializer parseArrayInitializer() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readOperator("{");
        ArrayList<Java.ArrayInitializerOrRvalue> arrayList = new ArrayList<Java.ArrayInitializerOrRvalue>();
        while (!this.peekOperator("}")) {
            arrayList.add(this.parseVariableInitializer());
            if (this.peekOperator("}")) break;
            if (!this.peekOperator(",")) {
                this.throwParseException("\",\" or \"}\" expected");
            }
            this.eatToken();
        }
        this.eatToken();
        return new Java.ArrayInitializer(location, arrayList.toArray(new Java.ArrayInitializerOrRvalue[arrayList.size()]));
    }

    public Java.Atom parseAssignmentExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalExpression();
        if (this.peekOperator(new String[]{"=", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="})) {
            Location location = this.location();
            String string = this.readOperator();
            Java.Lvalue lvalue = atom.toLvalueOrPE();
            Java.Rvalue rvalue = this.parseAssignmentExpression().toRvalueOrPE();
            return new Java.Assignment(location, lvalue, string, rvalue);
        }
        return atom;
    }

    public Java.Block parseBlock() throws ParseException, Scanner.ScanException, IOException {
        Java.Block block = new Java.Block(this.location());
        this.readOperator("{");
        block.addStatements(this.parseBlockStatements());
        this.readOperator("}");
        return block;
    }

    public Java.BlockStatement parseBlockStatement() throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":") || this.peekKeyword(new String[]{"if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue"}) || this.peekOperator(new String[]{"{", ";"})) {
            return this.parseStatement();
        }
        if (this.peekKeyword("class")) {
            String string = this.scanner.doc();
            if (string == null) {
                this.warning("LCDCM", "Local class doc comment missing", this.location());
            }
            this.eatToken();
            Java.LocalClassDeclaration localClassDeclaration = (Java.LocalClassDeclaration)this.parseClassDeclarationRest(string, (short)18, ClassDeclarationContext.BLOCK);
            return new Java.LocalClassDeclarationStatement(localClassDeclaration);
        }
        if (this.peekKeyword("final")) {
            Location location = this.location();
            this.eatToken();
            Java.Type type = this.parseType();
            Java.LocalVariableDeclarationStatement localVariableDeclarationStatement = new Java.LocalVariableDeclarationStatement(location, 16, type, this.parseLocalVariableDeclarators());
            this.readOperator(";");
            return localVariableDeclarationStatement;
        }
        Java.Atom atom = this.parseExpression();
        if (this.peekOperator(";")) {
            this.eatToken();
            return new Java.ExpressionStatement(atom.toRvalueOrPE());
        }
        Java.Type type = atom.toTypeOrPE();
        Java.LocalVariableDeclarationStatement localVariableDeclarationStatement = new Java.LocalVariableDeclarationStatement(atom.getLocation(), 0, type, this.parseLocalVariableDeclarators());
        this.readOperator(";");
        return localVariableDeclarationStatement;
    }

    public List parseBlockStatements() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.BlockStatement> arrayList = new ArrayList<Java.BlockStatement>();
        while (!(this.peekOperator("}") || this.peekKeyword("case") || this.peekKeyword("default"))) {
            arrayList.add(this.parseBlockStatement());
        }
        return arrayList;
    }

    int parseBracketsOpt() throws Scanner.ScanException, IOException {
        int n = 0;
        while (this.scanner.peek().isOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
            this.eatToken();
            this.eatToken();
            ++n;
        }
        return n;
    }

    public Java.Statement parseBreakStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("break");
        String string = null;
        if (this.scanner.peek().isIdentifier()) {
            string = this.readIdentifier();
        }
        this.readOperator(";");
        return new Java.BreakStatement(location, string);
    }

    public void parseClassBody(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (!this.peekOperator("{")) {
            this.throwParseException("\"{\" expected at start of class body");
        }
        this.eatToken();
        while (true) {
            if (this.peekOperator("}")) {
                this.eatToken();
                return;
            }
            this.parseClassBodyDeclaration(classDeclaration);
        }
    }

    public void parseClassBodyDeclaration(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator(";")) {
            this.eatToken();
            return;
        }
        String string = this.scanner.doc();
        short s = this.parseModifiersOpt();
        if (this.peekOperator("{")) {
            if ((s & 0xFFFFFFF7) != 0) {
                this.throwParseException("Only modifier \"static\" allowed on initializer");
            }
            Java.Initializer initializer = new Java.Initializer(this.location(), (s & 8) != 0, this.parseBlock());
            classDeclaration.addVariableDeclaratorOrInitializer(initializer);
            return;
        }
        if (this.peekKeyword("void")) {
            Location location = this.location();
            this.eatToken();
            if (string == null) {
                this.warning("MDCM", "Method doc comment missing", location);
            }
            String string2 = this.readIdentifier();
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(string, s, new Java.BasicType(location, 0), string2));
            return;
        }
        if (this.peekKeyword("class")) {
            if (string == null) {
                this.warning("MCDCM", "Member class doc comment missing", this.location());
            }
            this.eatToken();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(string, s, ClassDeclarationContext.TYPE_DECLARATION)));
            return;
        }
        if (this.peekKeyword("interface")) {
            if (string == null) {
                this.warning("MIDCM", "Member interface doc comment missing", this.location());
            }
            this.eatToken();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(string, (short)(s | 8), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
            return;
        }
        if (classDeclaration instanceof Java.NamedClassDeclaration && this.scanner.peek().isIdentifier(((Java.NamedClassDeclaration)classDeclaration).getName()) && this.scanner.peekNextButOne().isOperator("(")) {
            if (string == null) {
                this.warning("CDCM", "Constructor doc comment missing", this.location());
            }
            classDeclaration.addConstructor(this.parseConstructorDeclarator(string, s));
            return;
        }
        Java.Type type = this.parseType();
        Location location = this.location();
        String string3 = this.readIdentifier();
        if (this.peekOperator("(")) {
            if (string == null) {
                this.warning("MDCM", "Method doc comment missing", this.location());
            }
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(string, s, type, string3));
            return;
        }
        if (string == null) {
            this.warning("FDCM", "Field doc comment missing", this.location());
        }
        Java.FieldDeclaration fieldDeclaration = new Java.FieldDeclaration(location, string, s, type, this.parseFieldDeclarationRest(string3));
        this.readOperator(";");
        classDeclaration.addVariableDeclaratorOrInitializer(fieldDeclaration);
    }

    public Java.NamedClassDeclaration parseClassDeclarationRest(String string, short s, ClassDeclarationContext classDeclarationContext) throws ParseException, Scanner.ScanException, IOException {
        Java.NamedClassDeclaration namedClassDeclaration;
        Location location = this.location();
        String string2 = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(string2, location);
        Java.ReferenceType referenceType = null;
        if (this.peekKeyword("extends")) {
            this.eatToken();
            referenceType = this.parseReferenceType();
        }
        Java.Type[] typeArray = new Java.ReferenceType[]{};
        if (this.peekKeyword("implements")) {
            this.eatToken();
            typeArray = this.parseReferenceTypeList();
        }
        if (classDeclarationContext == ClassDeclarationContext.COMPILATION_UNIT) {
            namedClassDeclaration = new Java.PackageMemberClassDeclaration(location, string, s, string2, referenceType, typeArray);
        } else if (classDeclarationContext == ClassDeclarationContext.TYPE_DECLARATION) {
            namedClassDeclaration = new Java.MemberClassDeclaration(location, string, s, string2, referenceType, typeArray);
        } else if (classDeclarationContext == ClassDeclarationContext.BLOCK) {
            namedClassDeclaration = new Java.LocalClassDeclaration(location, string, s, string2, referenceType, typeArray);
        } else {
            throw new RuntimeException("SNO: Class declaration in unexpected context " + classDeclarationContext);
        }
        this.parseClassBody(namedClassDeclaration);
        return namedClassDeclaration;
    }

    public Java.CompilationUnit parseCompilationUnit() throws ParseException, Scanner.ScanException, IOException {
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(this.location().getFileName());
        if (this.peekKeyword("package")) {
            compilationUnit.setPackageDeclaration(this.parsePackageDeclaration());
        }
        while (this.peekKeyword("import")) {
            compilationUnit.addImportDeclaration(this.parseImportDeclaration());
        }
        while (!this.scanner.peek().isEOF()) {
            if (this.peekOperator(";")) {
                this.eatToken();
                continue;
            }
            compilationUnit.addPackageMemberTypeDeclaration(this.parsePackageMemberTypeDeclaration());
        }
        return compilationUnit;
    }

    public Java.Atom parseConditionalAndExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseInclusiveOrExpression();
        while (this.peekOperator("&&")) {
            Location location = this.location();
            this.eatToken();
            atom = new Java.BinaryOperation(location, atom.toRvalueOrPE(), "&&", this.parseInclusiveOrExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseConditionalExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalOrExpression();
        if (!this.peekOperator("?")) {
            return atom;
        }
        Location location = this.location();
        this.eatToken();
        Java.Rvalue rvalue = atom.toRvalueOrPE();
        Java.Rvalue rvalue2 = this.parseExpression().toRvalueOrPE();
        this.readOperator(":");
        Java.Rvalue rvalue3 = this.parseConditionalExpression().toRvalueOrPE();
        return new Java.ConditionalExpression(location, rvalue, rvalue2, rvalue3);
    }

    public Java.Atom parseConditionalOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalAndExpression();
        while (this.peekOperator("||")) {
            Location location = this.location();
            this.eatToken();
            atom = new Java.BinaryOperation(location, atom.toRvalueOrPE(), "||", this.parseConditionalAndExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.ConstructorDeclarator parseConstructorDeclarator(String string, short s) throws ParseException, Scanner.ScanException, IOException {
        Java.Type[] typeArray;
        Location location = this.location();
        this.readIdentifier();
        Java.FunctionDeclarator.FormalParameter[] formalParameterArray = this.parseFormalParameters();
        if (this.peekKeyword("throws")) {
            this.eatToken();
            typeArray = this.parseReferenceTypeList();
        } else {
            typeArray = new Java.ReferenceType[]{};
        }
        location = this.location();
        this.readOperator("{");
        Java.ConstructorInvocation constructorInvocation = null;
        Java.Block block = new Java.Block(location);
        if (this.peekKeyword(new String[]{"this", "super", "new", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean"}) || this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier()) {
            Java.Atom atom = this.parseExpression();
            if (atom instanceof Java.ConstructorInvocation) {
                this.readOperator(";");
                constructorInvocation = (Java.ConstructorInvocation)atom;
            } else {
                Java.Statement statement;
                if (this.scanner.peek().isIdentifier()) {
                    Java.Type type = atom.toTypeOrPE();
                    statement = new Java.LocalVariableDeclarationStatement(atom.getLocation(), 0, type, this.parseLocalVariableDeclarators());
                    this.readOperator(";");
                } else {
                    statement = new Java.ExpressionStatement(atom.toRvalueOrPE());
                    this.readOperator(";");
                }
                block.addStatement(statement);
            }
        }
        block.addStatements(this.parseBlockStatements());
        this.readOperator("}");
        return new Java.ConstructorDeclarator(location, string, s, formalParameterArray, typeArray, constructorInvocation, block);
    }

    public Java.Statement parseContinueStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("continue");
        String string = null;
        if (this.scanner.peek().isIdentifier()) {
            string = this.readIdentifier();
        }
        this.readOperator(";");
        return new Java.ContinueStatement(location, string);
    }

    public Java.Rvalue parseDimExpr() throws Scanner.ScanException, ParseException, IOException {
        this.readOperator("[");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator("]");
        return rvalue;
    }

    public Java.Rvalue[] parseDimExprs() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        arrayList.add(this.parseDimExpr());
        while (this.peekOperator("[") && !this.scanner.peekNextButOne().isOperator("]")) {
            arrayList.add(this.parseDimExpr());
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Statement parseDoStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("do");
        Java.Statement statement = this.parseStatement();
        this.readKeyword("while");
        this.readOperator("(");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        this.readOperator(";");
        return new Java.DoStatement(location, statement, rvalue);
    }

    public Java.Statement parseEmptyStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readOperator(";");
        return new Java.EmptyStatement(location);
    }

    public Java.Atom parseEqualityExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseRelationalExpression();
        while (this.peekOperator(new String[]{"==", "!="})) {
            atom = new Java.BinaryOperation(this.location(), atom.toRvalueOrPE(), this.readOperator(), this.parseRelationalExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseExclusiveOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseAndExpression();
        while (this.peekOperator("^")) {
            Location location = this.location();
            this.eatToken();
            atom = new Java.BinaryOperation(location, atom.toRvalueOrPE(), "^", this.parseAndExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseExpression() throws ParseException, Scanner.ScanException, IOException {
        return this.parseAssignmentExpression();
    }

    public Java.Rvalue[] parseExpressionList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        while (true) {
            arrayList.add(this.parseExpression().toRvalueOrPE());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Statement parseExpressionStatement() throws ParseException, Scanner.ScanException, IOException {
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ExpressionStatement(rvalue);
    }

    public Java.VariableDeclarator[] parseFieldDeclarationRest(String string) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> arrayList = new ArrayList<Java.VariableDeclarator>();
        Java.VariableDeclarator variableDeclarator = this.parseVariableDeclaratorRest(string);
        this.verifyIdentifierIsConventionalFieldName(variableDeclarator.name, variableDeclarator.getLocation());
        arrayList.add(variableDeclarator);
        while (this.peekOperator(",")) {
            this.eatToken();
            variableDeclarator = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalFieldName(variableDeclarator.name, variableDeclarator.getLocation());
            arrayList.add(variableDeclarator);
        }
        return arrayList.toArray(new Java.VariableDeclarator[arrayList.size()]);
    }

    private Java.BlockStatement parseForInit() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekKeyword(new String[]{"final", "byte", "short", "char", "int", "long", "float", "double", "boolean"})) {
            short s = this.parseModifiersOpt();
            Java.Type type = this.parseType();
            return new Java.LocalVariableDeclarationStatement(this.location(), s, type, this.parseLocalVariableDeclarators());
        }
        Java.Atom atom = this.parseExpression();
        if (this.scanner.peek().isIdentifier()) {
            Java.Type type = atom.toTypeOrPE();
            return new Java.LocalVariableDeclarationStatement(atom.getLocation(), 0, type, this.parseLocalVariableDeclarators());
        }
        if (!this.peekOperator(",")) {
            return new Java.ExpressionStatement(atom.toRvalueOrPE());
        }
        this.eatToken();
        ArrayList<Java.ExpressionStatement> arrayList = new ArrayList<Java.ExpressionStatement>();
        arrayList.add(new Java.ExpressionStatement(atom.toRvalueOrPE()));
        while (true) {
            arrayList.add(new Java.ExpressionStatement(this.parseExpression().toRvalueOrPE()));
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        Java.Block block = new Java.Block(atom.getLocation());
        block.addStatements(arrayList);
        return block;
    }

    public Java.Statement parseForStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("for");
        this.readOperator("(");
        Java.BlockStatement blockStatement = null;
        if (!this.peekOperator(";")) {
            blockStatement = this.parseForInit();
        }
        this.readOperator(";");
        Java.Rvalue rvalue = null;
        if (!this.peekOperator(";")) {
            rvalue = this.parseExpression().toRvalueOrPE();
        }
        this.readOperator(";");
        Java.Rvalue[] rvalueArray = null;
        if (!this.peekOperator(")")) {
            rvalueArray = this.parseExpressionList();
        }
        this.readOperator(")");
        return new Java.ForStatement(location, blockStatement, rvalue, rvalueArray, this.parseStatement());
    }

    public Java.FunctionDeclarator.FormalParameter parseFormalParameter() throws ParseException, Scanner.ScanException, IOException {
        boolean bl = this.peekKeyword("final");
        if (bl) {
            this.eatToken();
        }
        Java.Type type = this.parseType();
        Location location = this.location();
        String string = this.readIdentifier();
        this.verifyIdentifierIsConventionalLocalVariableOrParameterName(string, location);
        int n = this.parseBracketsOpt();
        while (n > 0) {
            type = new Java.ArrayType(type);
            --n;
        }
        return new Java.FunctionDeclarator.FormalParameter(location, bl, type, string);
    }

    public Java.FunctionDeclarator.FormalParameter[] parseFormalParameters() throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("(");
        if (this.peekOperator(")")) {
            this.eatToken();
            return new Java.FunctionDeclarator.FormalParameter[0];
        }
        ArrayList<Java.FunctionDeclarator.FormalParameter> arrayList = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        while (true) {
            arrayList.add(this.parseFormalParameter());
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        this.readOperator(")");
        return arrayList.toArray(new Java.FunctionDeclarator.FormalParameter[arrayList.size()]);
    }

    public Java.Statement parseIfStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("if");
        this.readOperator("(");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        Java.Statement statement = this.parseStatement();
        Java.Statement statement2 = null;
        if (this.peekKeyword("else")) {
            this.eatToken();
            statement2 = this.parseStatement();
        }
        return new Java.IfStatement(location, rvalue, statement, statement2);
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclaration() throws ParseException, Scanner.ScanException, IOException {
        this.readKeyword("import");
        Java.CompilationUnit.ImportDeclaration importDeclaration = this.parseImportDeclarationBody();
        this.readOperator(";");
        return importDeclaration;
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclarationBody() throws ParseException, Scanner.ScanException, IOException {
        boolean bl;
        Location location = this.location();
        if (this.peekKeyword("static")) {
            bl = true;
            this.eatToken();
        } else {
            bl = false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.readIdentifier());
        while (true) {
            if (!this.peekOperator(".")) {
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return bl ? new Java.CompilationUnit.SingleStaticImportDeclaration(location, stringArray) : new Java.CompilationUnit.SingleTypeImportDeclaration(location, stringArray);
            }
            this.readOperator(".");
            if (this.peekOperator("*")) {
                this.eatToken();
                String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                return bl ? new Java.CompilationUnit.StaticImportOnDemandDeclaration(location, stringArray) : new Java.CompilationUnit.TypeImportOnDemandDeclaration(location, stringArray);
            }
            arrayList.add(this.readIdentifier());
        }
    }

    public Java.Atom parseInclusiveOrExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseExclusiveOrExpression();
        while (this.peekOperator("|")) {
            Location location = this.location();
            this.eatToken();
            atom = new Java.BinaryOperation(location, atom.toRvalueOrPE(), "|", this.parseExclusiveOrExpression().toRvalueOrPE());
        }
        return atom;
    }

    public void parseInterfaceBody(Java.InterfaceDeclaration interfaceDeclaration) throws ParseException, Scanner.ScanException, IOException {
        this.readOperator("{");
        while (true) {
            Object object;
            Object object2;
            if (this.peekOperator("}")) break;
            if (this.peekOperator(";")) {
                this.eatToken();
                continue;
            }
            String string = this.scanner.doc();
            short s = this.parseModifiersOpt();
            if (this.peekKeyword("void")) {
                if (string == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                object2 = this.location();
                this.eatToken();
                object = this.readIdentifier();
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(string, (short)(s | 0x400 | 1), new Java.BasicType((Location)object2, 0), (String)object));
                continue;
            }
            if (this.peekKeyword("class")) {
                if (string == null) {
                    this.warning("MCDCM", "Member class doc comment missing", this.location());
                }
                this.eatToken();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(string, (short)(s | 8 | 1), ClassDeclarationContext.TYPE_DECLARATION)));
                continue;
            }
            if (this.peekKeyword("interface")) {
                if (string == null) {
                    this.warning("MIDCM", "Member interface doc comment missing", this.location());
                }
                this.eatToken();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(string, (short)(s | 8 | 1), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
                continue;
            }
            object2 = this.parseType();
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Identifier expected in member declaration");
            }
            object = this.location();
            String string2 = this.readIdentifier();
            if (this.peekOperator("(")) {
                if (string == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(string, (short)(s | 0x400 | 1), (Java.Type)object2, string2));
                continue;
            }
            if (string == null) {
                this.warning("FDCM", "Field doc comment missing", this.location());
            }
            Java.FieldDeclaration fieldDeclaration = new Java.FieldDeclaration((Location)object, string, (short)(s | 1 | 8 | 0x10), (Java.Type)object2, this.parseFieldDeclarationRest(string2));
            interfaceDeclaration.addConstantDeclaration(fieldDeclaration);
        }
        this.eatToken();
    }

    public Java.InterfaceDeclaration parseInterfaceDeclarationRest(String string, short s, InterfaceDeclarationContext interfaceDeclarationContext) throws ParseException, Scanner.ScanException, IOException {
        Java.InterfaceDeclaration interfaceDeclaration;
        Location location = this.location();
        String string2 = this.readIdentifier();
        this.verifyIdentifierIsConventionalClassOrInterfaceName(string2, location);
        Java.Type[] typeArray = new Java.ReferenceType[]{};
        if (this.peekKeyword("extends")) {
            this.eatToken();
            typeArray = this.parseReferenceTypeList();
        }
        if (interfaceDeclarationContext == InterfaceDeclarationContext.COMPILATION_UNIT) {
            interfaceDeclaration = new Java.PackageMemberInterfaceDeclaration(location, string, s, string2, typeArray);
        } else if (interfaceDeclarationContext == InterfaceDeclarationContext.NAMED_TYPE_DECLARATION) {
            interfaceDeclaration = new Java.MemberInterfaceDeclaration(location, string, s, string2, typeArray);
        } else {
            throw new RuntimeException("SNO: Interface declaration in unexpected context " + interfaceDeclarationContext);
        }
        this.parseInterfaceBody(interfaceDeclaration);
        return interfaceDeclaration;
    }

    public Java.Statement parseLabeledStatement() throws ParseException, Scanner.ScanException, IOException {
        String string = this.readIdentifier();
        this.readOperator(":");
        return new Java.LabeledStatement(this.location(), string, this.parseStatement());
    }

    public Java.Atom parseLiteral() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token token = this.scanner.read();
        if (!token.isLiteral()) {
            this.throwParseException("Literal expected");
        }
        return new Java.Literal(token.getLocation(), token.getLiteralValue());
    }

    public Java.VariableDeclarator[] parseLocalVariableDeclarators() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> arrayList = new ArrayList<Java.VariableDeclarator>();
        while (true) {
            Java.VariableDeclarator variableDeclarator = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalLocalVariableOrParameterName(variableDeclarator.name, variableDeclarator.getLocation());
            arrayList.add(variableDeclarator);
            if (!this.peekOperator(",")) break;
            this.eatToken();
        }
        return arrayList.toArray(new Java.VariableDeclarator[arrayList.size()]);
    }

    public Java.Block parseMethodBody() throws ParseException, Scanner.ScanException, IOException {
        return this.parseBlock();
    }

    public Java.MethodDeclarator parseMethodDeclarationRest(String string, short s, Java.Type type, String string2) throws ParseException, Scanner.ScanException, IOException {
        Java.Block block;
        Java.Type[] typeArray;
        Location location = this.location();
        this.verifyIdentifierIsConventionalMethodName(string2, location);
        Java.FunctionDeclarator.FormalParameter[] formalParameterArray = this.parseFormalParameters();
        int n = this.parseBracketsOpt();
        while (n > 0) {
            type = new Java.ArrayType(type);
            --n;
        }
        if (this.peekKeyword("throws")) {
            this.eatToken();
            typeArray = this.parseReferenceTypeList();
        } else {
            typeArray = new Java.ReferenceType[]{};
        }
        if (this.peekOperator(";")) {
            if ((s & 0x500) == 0) {
                this.throwParseException("Non-abstract, non-native method must have a body");
            }
            this.eatToken();
            block = null;
        } else {
            if ((s & 0x500) != 0) {
                this.throwParseException("Abstract or native method must not have a body");
            }
            block = this.parseMethodBody();
        }
        return new Java.MethodDeclarator(location, string, s, type, string2, formalParameterArray, typeArray, block);
    }

    public short parseModifiersOpt() throws ParseException, Scanner.ScanException, IOException {
        short s = 0;
        while (this.peekKeyword()) {
            int n;
            String string = this.scanner.peek().getKeyword();
            int n2 = string == "public" ? 1 : (string == "protected" ? 4 : (string == "private" ? 2 : (string == "static" ? 8 : (string == "abstract" ? 1024 : (string == "final" ? 16 : (string == "native" ? 256 : (string == "synchronized" ? 32 : (string == "transient" ? 128 : (string == "volatile" ? 64 : (n = string == "strictfp" ? 2048 : -1))))))))));
            if (n == -1) break;
            this.eatToken();
            if ((s & n) != 0) {
                this.throwParseException("Duplicate modifier \"" + string + "\"");
            }
            int n3 = 0;
            while (n3 < MUTUALS.length) {
                short s2 = MUTUALS[n3];
                if ((n & s2) != 0 && (s & s2) != 0) {
                    this.throwParseException("Only one of \"" + Mod.shortToString(s2) + "\" allowed");
                }
                ++n3;
            }
            s = (short)(s | n);
        }
        return s;
    }

    public Java.Atom parseMultiplicativeExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseUnaryExpression();
        while (this.peekOperator(new String[]{"*", "/", "%"})) {
            atom = new Java.BinaryOperation(this.location(), atom.toRvalueOrPE(), this.readOperator(), this.parseUnaryExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.PackageDeclaration parsePackageDeclaration() throws ParseException, Scanner.ScanException, IOException {
        this.readKeyword("package");
        Location location = this.location();
        String string = Parser.join(this.parseQualifiedIdentifier(), ".");
        this.readOperator(";");
        this.verifyStringIsConventionalPackageName(string, location);
        return new Java.PackageDeclaration(location, string);
    }

    public Java.PackageMemberTypeDeclaration parsePackageMemberTypeDeclaration() throws ParseException, Scanner.ScanException, IOException {
        Java.AbstractTypeDeclaration abstractTypeDeclaration;
        String string = this.scanner.doc();
        short s = this.parseModifiersOpt();
        if (this.peekKeyword("class")) {
            if (string == null) {
                this.warning("CDCM", "Class doc comment missing", this.location());
            }
            this.eatToken();
            abstractTypeDeclaration = (Java.PackageMemberClassDeclaration)this.parseClassDeclarationRest(string, s, ClassDeclarationContext.COMPILATION_UNIT);
        } else if (this.peekKeyword("interface")) {
            if (string == null) {
                this.warning("IDCM", "Interface doc comment missing", this.location());
            }
            this.eatToken();
            abstractTypeDeclaration = (Java.PackageMemberInterfaceDeclaration)this.parseInterfaceDeclarationRest(string, s, InterfaceDeclarationContext.COMPILATION_UNIT);
        } else {
            this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in class or interface declaration");
            return null;
        }
        return abstractTypeDeclaration;
    }

    public Java.Atom parsePrimary() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator("(")) {
            this.eatToken();
            if (this.peekKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
                Java.Type type = this.parseType();
                int n = this.parseBracketsOpt();
                this.readOperator(")");
                int n2 = 0;
                while (n2 < n) {
                    type = new Java.ArrayType(type);
                    ++n2;
                }
                return new Java.Cast(this.location(), type, this.parseUnaryExpression().toRvalueOrPE());
            }
            Java.Atom atom = this.parseExpression();
            this.readOperator(")");
            if (this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier() || this.peekOperator(new String[]{"(", "~", "!"}) || this.peekKeyword(new String[]{"this", "super", "new"})) {
                return new Java.Cast(this.location(), atom.toTypeOrPE(), this.parseUnaryExpression().toRvalueOrPE());
            }
            return new Java.ParenthesizedExpression(atom.getLocation(), atom.toRvalueOrPE());
        }
        if (this.scanner.peek().isLiteral()) {
            return this.parseLiteral();
        }
        if (this.scanner.peek().isIdentifier()) {
            Location location = this.location();
            String[] stringArray = this.parseQualifiedIdentifier();
            if (this.peekOperator("(")) {
                return new Java.MethodInvocation(this.location(), stringArray.length == 1 ? null : new Java.AmbiguousName(location, stringArray, stringArray.length - 1), stringArray[stringArray.length - 1], this.parseArguments());
            }
            if (this.peekOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
                Java.Type type = new Java.ReferenceType(location, stringArray);
                int n = this.parseBracketsOpt();
                int n3 = 0;
                while (n3 < n) {
                    type = new Java.ArrayType(type);
                    ++n3;
                }
                if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                    this.eatToken();
                    Location location2 = this.location();
                    this.eatToken();
                    return new Java.ClassLiteral(location2, type);
                }
                return type;
            }
            return new Java.AmbiguousName(this.location(), stringArray);
        }
        if (this.peekKeyword("this")) {
            Location location = this.location();
            this.eatToken();
            if (this.peekOperator("(")) {
                return new Java.AlternateConstructorInvocation(location, this.parseArguments());
            }
            return new Java.ThisReference(location);
        }
        if (this.peekKeyword("super")) {
            this.eatToken();
            if (this.peekOperator("(")) {
                return new Java.SuperConstructorInvocation(this.location(), null, this.parseArguments());
            }
            this.readOperator(".");
            String string = this.readIdentifier();
            if (this.peekOperator("(")) {
                return new Java.SuperclassMethodInvocation(this.location(), string, this.parseArguments());
            }
            return new Java.SuperclassFieldAccessExpression(this.location(), null, string);
        }
        if (this.peekKeyword("new")) {
            Location location = this.location();
            this.eatToken();
            Java.Type type = this.parseType();
            if (type instanceof Java.ArrayType) {
                return new Java.NewInitializedArray(location, (Java.ArrayType)type, this.parseArrayInitializer());
            }
            if (type instanceof Java.ReferenceType && this.peekOperator("(")) {
                Java.Rvalue[] rvalueArray = this.parseArguments();
                if (this.peekOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, null, anonymousClassDeclaration, rvalueArray);
                }
                return new Java.NewClassInstance(location, null, type, rvalueArray);
            }
            return new Java.NewArray(location, type, this.parseDimExprs(), this.parseBracketsOpt());
        }
        if (this.peekKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
            Java.Type type = this.parseType();
            int n = this.parseBracketsOpt();
            int n4 = 0;
            while (n4 < n) {
                type = new Java.ArrayType(type);
                ++n4;
            }
            if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.eatToken();
                Location location = this.location();
                this.eatToken();
                return new Java.ClassLiteral(location, type);
            }
            return type;
        }
        if (this.peekKeyword("void")) {
            this.eatToken();
            if (this.peekOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.eatToken();
                Location location = this.location();
                this.eatToken();
                return new Java.ClassLiteral(location, new Java.BasicType(location, 0));
            }
            this.throwParseException("\"void\" encountered in wrong context");
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in primary");
        return null;
    }

    public String[] parseQualifiedIdentifier() throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Identifier expected");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.readIdentifier());
        while (this.peekOperator(".") && this.scanner.peekNextButOne().isIdentifier()) {
            this.eatToken();
            arrayList.add(this.readIdentifier());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Java.ReferenceType parseReferenceType() throws ParseException, Scanner.ScanException, IOException {
        return new Java.ReferenceType(this.location(), this.parseQualifiedIdentifier());
    }

    public Java.ReferenceType[] parseReferenceTypeList() throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.ReferenceType> arrayList = new ArrayList<Java.ReferenceType>();
        arrayList.add(this.parseReferenceType());
        while (this.peekOperator(",")) {
            this.eatToken();
            arrayList.add(this.parseReferenceType());
        }
        return arrayList.toArray(new Java.ReferenceType[arrayList.size()]);
    }

    public Java.Atom parseRelationalExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseShiftExpression();
        while (true) {
            if (this.peekKeyword("instanceof")) {
                Location location = this.location();
                this.eatToken();
                atom = new Java.Instanceof(location, atom.toRvalueOrPE(), this.parseType());
                continue;
            }
            if (!this.peekOperator(new String[]{"<", ">", "<=", ">="})) break;
            atom = new Java.BinaryOperation(this.location(), atom.toRvalueOrPE(), this.readOperator(), this.parseShiftExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Statement parseReturnStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("return");
        Java.Rvalue rvalue = this.peekOperator(";") ? null : this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ReturnStatement(location, rvalue);
    }

    public Java.Atom parseSelector(Java.Atom atom) throws ParseException, Scanner.ScanException, IOException {
        Object object;
        Object object2;
        if (this.peekOperator(".")) {
            this.eatToken();
            if (this.scanner.peek().isIdentifier()) {
                String string = this.readIdentifier();
                if (this.peekOperator("(")) {
                    return new Java.MethodInvocation(this.location(), atom.toRvalueOrPE(), string, this.parseArguments());
                }
                return new Java.FieldAccessExpression(this.location(), atom.toRvalueOrPE(), string);
            }
            if (this.peekKeyword("this")) {
                Location location = this.location();
                this.eatToken();
                return new Java.QualifiedThisReference(location, atom.toTypeOrPE());
            }
            if (this.peekKeyword("super")) {
                object2 = this.location();
                this.eatToken();
                if (this.peekOperator("(")) {
                    return new Java.SuperConstructorInvocation((Location)object2, atom.toRvalueOrPE(), this.parseArguments());
                }
                this.readOperator(".");
                object = this.readIdentifier();
                if (this.peekOperator("(")) {
                    this.throwParseException("Qualified superclass method invocation NYI");
                } else {
                    return new Java.SuperclassFieldAccessExpression((Location)object2, atom.toTypeOrPE(), (String)object);
                }
            }
            if (this.peekKeyword("new")) {
                object2 = atom.toRvalue();
                object = this.location();
                this.eatToken();
                String string = this.readIdentifier();
                Java.RvalueMemberType rvalueMemberType = new Java.RvalueMemberType((Location)object, (Java.Rvalue)object2, string);
                Java.Rvalue[] rvalueArray = this.parseArguments();
                if (this.peekOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), rvalueMemberType);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance((Location)object, (Java.Rvalue)object2, anonymousClassDeclaration, rvalueArray);
                }
                return new Java.NewClassInstance((Location)object, (Java.Rvalue)object2, rvalueMemberType, rvalueArray);
            }
            if (this.peekKeyword("class")) {
                object2 = this.location();
                this.eatToken();
                return new Java.ClassLiteral((Location)object2, atom.toTypeOrPE());
            }
            this.throwParseException("Unexpected selector \"" + this.scanner.peek() + "\" after \".\"");
        }
        if (this.peekOperator("[")) {
            object2 = this.location();
            this.eatToken();
            object = this.parseExpression().toRvalueOrPE();
            this.readOperator("]");
            return new Java.ArrayAccessExpression((Location)object2, atom.toRvalueOrPE(), (Java.Rvalue)object);
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in selector");
        return null;
    }

    public Java.Atom parseShiftExpression() throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseAdditiveExpression();
        while (this.peekOperator(new String[]{"<<", ">>", ">>>"})) {
            atom = new Java.BinaryOperation(this.location(), atom.toRvalueOrPE(), this.readOperator(), this.parseAdditiveExpression().toRvalueOrPE());
        }
        return atom;
    }

    public Java.Statement parseStatement() throws ParseException, Scanner.ScanException, IOException {
        Java.Block block;
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":")) {
            return this.parseLabeledStatement();
        }
        Scanner.Token token = this.scanner.peek();
        Java.Statement statement = token.isOperator("{") ? this.parseBlock() : (token.isKeyword("if") ? this.parseIfStatement() : (token.isKeyword("for") ? this.parseForStatement() : (token.isKeyword("while") ? this.parseWhileStatement() : (token.isKeyword("do") ? this.parseDoStatement() : (token.isKeyword("try") ? this.parseTryStatement() : (token.isKeyword("switch") ? this.parseSwitchStatement() : (token.isKeyword("synchronized") ? this.parseSynchronizedStatement() : (token.isKeyword("return") ? this.parseReturnStatement() : (token.isKeyword("throw") ? this.parseThrowStatement() : (token.isKeyword("break") ? this.parseBreakStatement() : (token.isKeyword("continue") ? this.parseContinueStatement() : (block = token.isOperator(";") ? this.parseEmptyStatement() : this.parseExpressionStatement()))))))))))));
        if (block == null) {
            this.throwParseException("\"" + token.getKeyword() + "\" NYI");
        }
        return block;
    }

    public Java.Statement parseSwitchStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("switch");
        this.readOperator("(");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        this.readOperator("{");
        ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup> arrayList = new ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup>();
        while (!this.peekOperator("}")) {
            Location location2 = this.location();
            boolean bl = false;
            ArrayList<Java.Rvalue> arrayList2 = new ArrayList<Java.Rvalue>();
            do {
                if (this.peekKeyword("case")) {
                    this.eatToken();
                    arrayList2.add(this.parseExpression().toRvalueOrPE());
                } else if (this.peekKeyword("default")) {
                    this.eatToken();
                    if (bl) {
                        this.throwParseException("Duplicate \"default\" label");
                    }
                    bl = true;
                } else {
                    this.throwParseException("\"case\" or \"default\" expected");
                }
                this.readOperator(":");
            } while (this.peekKeyword(new String[]{"case", "default"}));
            Java.SwitchStatement.SwitchBlockStatementGroup switchBlockStatementGroup = new Java.SwitchStatement.SwitchBlockStatementGroup(location2, arrayList2, bl, this.parseBlockStatements());
            arrayList.add(switchBlockStatementGroup);
        }
        this.eatToken();
        return new Java.SwitchStatement(location, rvalue, arrayList);
    }

    public Java.Statement parseSynchronizedStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("synchronized");
        this.readOperator("(");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        return new Java.SynchronizedStatement(location, rvalue, this.parseBlock());
    }

    public Java.Statement parseThrowStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("throw");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(";");
        return new Java.ThrowStatement(location, rvalue);
    }

    public Java.Statement parseTryStatement() throws ParseException, Scanner.ScanException, IOException {
        Object object;
        Location location = this.location();
        this.readKeyword("try");
        Java.Block block = this.parseBlock();
        ArrayList<Java.CatchClause> arrayList = new ArrayList<Java.CatchClause>();
        while (this.peekKeyword("catch")) {
            object = this.location();
            this.eatToken();
            this.readOperator("(");
            Java.FunctionDeclarator.FormalParameter formalParameter = this.parseFormalParameter();
            this.readOperator(")");
            arrayList.add(new Java.CatchClause((Location)object, formalParameter, this.parseBlock()));
        }
        object = null;
        if (this.peekKeyword("finally")) {
            this.eatToken();
            object = this.parseBlock();
        }
        if (arrayList.size() == 0 && object == null) {
            this.throwParseException("\"try\" statement must have at least one \"catch\" clause or a \"finally\" clause");
        }
        return new Java.TryStatement(location, block, arrayList, (Java.Block)object);
    }

    public Java.Type parseType() throws ParseException, Scanner.ScanException, IOException {
        Java.Type type;
        Scanner.Token token = this.scanner.peek();
        int n = -1;
        if (token.isKeyword("byte")) {
            n = 1;
        } else if (token.isKeyword("short")) {
            n = 2;
        } else if (token.isKeyword("char")) {
            n = 3;
        } else if (token.isKeyword("int")) {
            n = 4;
        } else if (token.isKeyword("long")) {
            n = 5;
        } else if (token.isKeyword("float")) {
            n = 6;
        } else if (token.isKeyword("double")) {
            n = 7;
        } else if (token.isKeyword("boolean")) {
            n = 8;
        }
        if (n != -1) {
            type = new Java.BasicType(token.getLocation(), n);
            this.eatToken();
        } else {
            type = this.parseReferenceType();
        }
        int n2 = this.parseBracketsOpt();
        while (n2 > 0) {
            type = new Java.ArrayType(type);
            --n2;
        }
        return type;
    }

    public Java.Atom parseUnaryExpression() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator(new String[]{"++", "--"})) {
            return new Java.Crement(this.location(), this.readOperator(), this.parseUnaryExpression().toLvalueOrPE());
        }
        if (this.peekOperator(new String[]{"+", "-", "~", "!"})) {
            return new Java.UnaryOperation(this.location(), this.readOperator(), this.parseUnaryExpression().toRvalueOrPE());
        }
        Java.Atom atom = this.parsePrimary();
        while (this.peekOperator(new String[]{".", "["})) {
            atom = this.parseSelector(atom);
        }
        while (this.peekOperator(new String[]{"++", "--"})) {
            atom = new Java.Crement(this.location(), atom.toLvalueOrPE(), this.readOperator());
        }
        return atom;
    }

    public Java.VariableDeclarator parseVariableDeclarator() throws ParseException, Scanner.ScanException, IOException {
        return this.parseVariableDeclaratorRest(this.readIdentifier());
    }

    public Java.VariableDeclarator parseVariableDeclaratorRest(String string) throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        int n = this.parseBracketsOpt();
        Java.ArrayInitializerOrRvalue arrayInitializerOrRvalue = null;
        if (this.peekOperator("=")) {
            this.eatToken();
            arrayInitializerOrRvalue = this.parseVariableInitializer();
        }
        return new Java.VariableDeclarator(location, string, n, arrayInitializerOrRvalue);
    }

    public Java.ArrayInitializerOrRvalue parseVariableInitializer() throws ParseException, Scanner.ScanException, IOException {
        if (this.peekOperator("{")) {
            return this.parseArrayInitializer();
        }
        return this.parseExpression().toRvalueOrPE();
    }

    public Java.Statement parseWhileStatement() throws ParseException, Scanner.ScanException, IOException {
        Location location = this.location();
        this.readKeyword("while");
        this.readOperator("(");
        Java.Rvalue rvalue = this.parseExpression().toRvalueOrPE();
        this.readOperator(")");
        return new Java.WhileStatement(location, rvalue, this.parseStatement());
    }

    public boolean peekIdentifier() {
        return this.scanner.peek().isIdentifier();
    }

    public boolean peekKeyword() {
        return this.scanner.peek().isKeyword();
    }

    public boolean peekKeyword(String string) {
        return this.scanner.peek().isKeyword(string);
    }

    public boolean peekKeyword(String[] stringArray) {
        return this.scanner.peek().isKeyword(stringArray);
    }

    public boolean peekOperator(String string) {
        return this.scanner.peek().isOperator(string);
    }

    public boolean peekOperator(String[] stringArray) {
        return this.scanner.peek().isOperator(stringArray);
    }

    public String readIdentifier() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token token = this.scanner.read();
        if (!token.isIdentifier()) {
            this.throwParseException("Identifier expected");
        }
        return token.getIdentifier();
    }

    public void readKeyword(String string) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isKeyword(string)) {
            this.throwParseException("\"" + string + "\" expected");
        }
    }

    public String readOperator() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token token = this.scanner.read();
        if (!token.isOperator()) {
            this.throwParseException("Operator expected");
        }
        return token.getOperator();
    }

    public void readOperator(String string) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isOperator(string)) {
            this.throwParseException("Operator \"" + string + "\" expected");
        }
    }

    public void setWarningHandler(WarningHandler warningHandler) {
        this.optionalWarningHandler = warningHandler;
    }

    protected final void throwParseException(String string) throws ParseException {
        throw new ParseException(string, this.location());
    }

    private void verifyIdentifierIsConventionalClassOrInterfaceName(String string, Location location) {
        if (!Character.isUpperCase(string.charAt(0))) {
            this.warning("UCOIN1", "Class or interface name \"" + string + "\" does not begin with an upper-case letter (see JLS2 6.8.2)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                this.warning("UCOIN", "Class or interface name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.2)", location);
                return;
            }
            ++n;
        }
    }

    private void verifyIdentifierIsConventionalFieldName(String string, Location location) {
        if (Character.isUpperCase(string.charAt(0))) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isUpperCase(c) && !Character.isDigit(c) && c != '_') {
                    this.warning("UCN", "Constant name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.5)", location);
                    return;
                }
                ++n;
            }
        } else if (Character.isLowerCase(string.charAt(0))) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isLetter(c) && !Character.isDigit(c)) {
                    this.warning("UFN", "Field name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.4)", location);
                    return;
                }
                ++n;
            }
        } else {
            this.warning("UFN1", "\"" + string + "\" is neither a conventional field name (JLS2 6.8.4) nor a conventional constant name (JLS2 6.8.5)", location);
        }
    }

    private void verifyIdentifierIsConventionalLocalVariableOrParameterName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            this.warning("ULVN1", "Local variable name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.6)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                this.warning("ULVN", "Local variable name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.6)", location);
                return;
            }
            ++n;
        }
    }

    private void verifyIdentifierIsConventionalMethodName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            this.warning("UMN1", "Method name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.3)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                this.warning("UMN", "Method name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.3)", location);
                return;
            }
            ++n;
        }
    }

    private void verifyStringIsConventionalPackageName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            this.warning("UPN", "Package name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.1)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLowerCase(c) && c != '_' && c != '.') {
                this.warning("PPN", "Poorly chosen package name \"" + string + "\" contains bad character '" + c + "'", location);
                return;
            }
            ++n;
        }
    }

    private void warning(String string, String string2, Location location) {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(string, string2, location);
        }
    }

    public static class ClassDeclarationContext
    extends Enumerator {
        public static final ClassDeclarationContext BLOCK = new ClassDeclarationContext("block");
        public static final ClassDeclarationContext TYPE_DECLARATION = new ClassDeclarationContext("type_declaration");
        public static final ClassDeclarationContext COMPILATION_UNIT = new ClassDeclarationContext("compilation_unit");

        private ClassDeclarationContext(String string) {
            super(string);
        }
    }

    public static class InterfaceDeclarationContext
    extends Enumerator {
        public static final InterfaceDeclarationContext NAMED_TYPE_DECLARATION = new InterfaceDeclarationContext("named_type_declaration");
        public static final InterfaceDeclarationContext COMPILATION_UNIT = new InterfaceDeclarationContext("compilation_unit");

        private InterfaceDeclarationContext(String string) {
            super(string);
        }
    }

    public static class ParseException
    extends Scanner.LocatedException {
        public ParseException(String string, Location location) {
            super(string, location);
        }
    }
}

