/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.samlext.saml2mdui.Logo;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLogoTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 6451849117572923712L;
    private static Logger log = LoggerFactory.getLogger(ServiceLogoTag.class);
    private static final String DEFAULT_VALUE = "";
    private static final String DEFAULT_ALT_TXT = "SP Logo";
    private int minWidth;
    private int maxWidth = Integer.MAX_VALUE;
    private int minHeight;
    private int maxHeight = Integer.MAX_VALUE;
    private String altTxt;

    public void setMaxWidth(Integer value) {
        this.maxWidth = value;
    }

    public void setMinWidth(Integer value) {
        this.minWidth = value;
    }

    public void setMinHeight(Integer value) {
        this.minHeight = value;
    }

    public void setMaxHeight(Integer value) {
        this.maxHeight = value;
    }

    public void setAlt(String value) {
        this.altTxt = value;
    }

    private boolean logoFits(Logo logo) {
        return logo.getHeight() <= this.maxHeight && logo.getHeight() >= this.minHeight && logo.getWidth() <= this.maxWidth && logo.getWidth() >= this.minWidth;
    }

    private String getLogoFromUIInfo(List<Logo> logos) {
        for (String lang : this.getBrowserLanguages()) {
            for (Logo logo : logos) {
                log.debug("Found logo in UIInfo, language=" + logo.getXMLLang() + " width=" + logo.getWidth() + " height=" + logo.getHeight());
                if (null == logo.getXMLLang() || !logo.getXMLLang().equals(lang) || !this.logoFits(logo)) continue;
                log.debug("returning logo from UIInfo " + logo.getURL());
                return logo.getURL();
            }
        }
        for (Logo logo : this.getSPUIInfo().getLogos()) {
            log.debug("Found logo in UIInfo, language=" + logo.getXMLLang() + " width=" + logo.getWidth() + " height=" + logo.getHeight());
            if (null != logo.getXMLLang() || !this.logoFits(logo)) continue;
            log.debug("returning logo from UIInfo " + logo.getURL());
            return logo.getURL();
        }
        return null;
    }

    private String getLogoFromUIInfo() {
        if (this.getSPUIInfo() != null && this.getSPUIInfo().getLogos() != null) {
            String result = this.getLogoFromUIInfo(this.getSPUIInfo().getLogos());
            if (null != result) {
                return result;
            }
            log.debug("No appropriate logo in UIInfo");
        }
        return null;
    }

    private String getAltText() {
        String value = this.altTxt;
        if (null != value && 0 != value.length()) {
            return value;
        }
        value = this.getServiceName();
        if (null != value && 0 != value.length()) {
            return value;
        }
        return DEFAULT_ALT_TXT;
    }

    private String getHyperlink() {
        String url = this.getLogoFromUIInfo();
        Encoder esapiEncoder = ESAPI.encoder();
        if (null == url) {
            return null;
        }
        try {
            URI theUrl = new URI(url);
            String scheme = theUrl.getScheme();
            if (!("http".equals(scheme) || "https".equals(scheme) || "mailto".equals(scheme))) {
                log.warn("The logo URL " + url + " contained an invalid scheme");
                return null;
            }
        }
        catch (URISyntaxException e) {
            log.warn("The logo URL " + url + " was not a URL " + e.toString());
            return null;
        }
        String encodedURL = esapiEncoder.encodeForHTMLAttribute(url);
        String encodedAltTxt = esapiEncoder.encodeForHTMLAttribute(this.getAltText());
        StringBuilder sb = new StringBuilder("<img src=\"");
        sb.append(encodedURL).append('\"');
        sb.append(" alt=\"").append(encodedAltTxt).append('\"');
        this.addClassAndId(sb);
        sb.append("/>");
        return sb.toString();
    }

    public int doEndTag() throws JspException {
        String result = this.getHyperlink();
        try {
            if (null == result) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                boolean written = false;
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                    written = true;
                }
                if (!written) {
                    this.pageContext.getOut().print(DEFAULT_VALUE);
                }
            } else {
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating Description");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

