/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.authn.provider;

import edu.internet2.middleware.shibboleth.idp.authn.LoginContext;
import edu.internet2.middleware.shibboleth.idp.authn.provider.AbstractLoginHandler;
import edu.internet2.middleware.shibboleth.idp.authn.provider.RemoteUserLoginHandler;
import edu.internet2.middleware.shibboleth.idp.util.HttpServletHelper;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalAuthnSystemLoginHandler
extends AbstractLoginHandler {
    public static final String FORCE_AUTHN_PARAM = "forceAuthn";
    public static final String PASSIVE_AUTHN_PARAM = "isPassive";
    public static final String AUTHN_METHOD_PARAM = "authnMethod";
    public static final String RELYING_PARTY_PARAM = "relyingParty";
    private final Logger log = LoggerFactory.getLogger(RemoteUserLoginHandler.class);
    private String externalAuthnPath;

    public String getExternalAuthnPath() {
        return this.externalAuthnPath;
    }

    public void setExternalAuthnPath(String path) {
        String trimmedPath = DatatypeHelper.safeTrimOrNullString((String)path);
        if (trimmedPath == null) {
            throw new IllegalArgumentException("External Authn path may not be null or empty");
        }
        this.externalAuthnPath = trimmedPath;
    }

    @Override
    public void login(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            this.log.debug("Forwarding authentication request to {}", (Object)this.externalAuthnPath);
            this.populateRequestAttributes(httpRequest);
            RequestDispatcher dispatcher = httpRequest.getRequestDispatcher(this.externalAuthnPath);
            dispatcher.forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        catch (IOException e) {
            this.log.error("Unable to forward authentication request to external authentication system.", (Throwable)e);
        }
        catch (ServletException e) {
            this.log.error("Unable to forward authentication request to external authentication system.", (Throwable)e);
        }
    }

    protected void populateRequestAttributes(HttpServletRequest httpRequest) {
        LoginContext loginContext = HttpServletHelper.getLoginContext(httpRequest);
        if (loginContext.isForceAuthRequired()) {
            httpRequest.setAttribute(FORCE_AUTHN_PARAM, (Object)Boolean.TRUE);
        } else {
            httpRequest.setAttribute(FORCE_AUTHN_PARAM, (Object)Boolean.FALSE);
        }
        if (loginContext.isPassiveAuthRequired()) {
            httpRequest.setAttribute(PASSIVE_AUTHN_PARAM, (Object)Boolean.TRUE);
        } else {
            httpRequest.setAttribute(PASSIVE_AUTHN_PARAM, (Object)Boolean.FALSE);
        }
        httpRequest.setAttribute(AUTHN_METHOD_PARAM, (Object)loginContext.getAttemptedAuthnMethod());
        httpRequest.setAttribute(RELYING_PARTY_PARAM, (Object)loginContext.getRelyingPartyId());
    }
}

