/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.bean;

import edu.vt.middleware.ldap.bean.AbstractLdapBean;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanFactory;
import edu.vt.middleware.ldap.bean.LdapEntry;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

public abstract class AbstractLdapEntry
extends AbstractLdapBean
implements LdapEntry {
    protected static final int HASH_CODE_SEED = 43;
    protected String dn;
    protected LdapAttributes ldapAttributes;

    public AbstractLdapEntry(LdapBeanFactory lbf) {
        super(lbf);
    }

    public String getDn() {
        return this.dn;
    }

    public LdapAttributes getLdapAttributes() {
        return this.ldapAttributes;
    }

    public void setEntry(SearchResult sr) throws NamingException {
        this.setDn(sr.getName());
        LdapAttributes la = this.beanFactory.newLdapAttributes();
        la.addAttributes(sr.getAttributes());
        this.setLdapAttributes(la);
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setLdapAttributes(LdapAttributes a) {
        if (a != null) {
            this.ldapAttributes = a;
        }
    }

    public int hashCode() {
        int hc = 43;
        if (this.getDn() != null) {
            hc += this.getDn().hashCode();
        }
        return hc += this.getLdapAttributes().hashCode();
    }

    public String toString() {
        return String.format("dn=>%s%s", this.dn, this.ldapAttributes);
    }

    public SearchResult toSearchResult() {
        return new SearchResult(this.dn, (Object)null, this.ldapAttributes.toAttributes());
    }
}

