/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security.saml;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import javax.xml.namespace.QName;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class IssueInstantRuleBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:security:saml", "IssueInstant");

    protected Class getBeanClass(Element element) {
        return IssueInstantRule.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        long skew = 300L;
        if (element.hasAttributeNS(null, "clockSkew")) {
            skew = SpringConfigurationUtils.parseDurationToMillis("'clockSkew' on security rule of type " + XMLHelper.getXSIType((Element)element), element.getAttributeNS(null, "clockSkew"), 1000) / 1000L;
        }
        builder.addConstructorArgValue((Object)skew);
        long expirationThreshold = 60L;
        if (element.hasAttributeNS(null, "expirationThreshold")) {
            expirationThreshold = SpringConfigurationUtils.parseDurationToMillis("'expirationThreshold' on security rule of type " + XMLHelper.getXSIType((Element)element), element.getAttributeNS(null, "expirationThreshold"), 1000) / 1000L;
        }
        builder.addConstructorArgValue((Object)expirationThreshold);
        if (element.hasAttributeNS(null, "required")) {
            builder.addPropertyValue("requiredRule", (Object)XMLHelper.getAttributeValueAsBoolean((Attr)element.getAttributeNodeNS(null, "required")));
        } else {
            builder.addPropertyValue("requiredRule", (Object)true);
        }
    }
}

