/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.xml.security.x509.BasicPKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class PKIXValidationInformationFactoryBean
extends AbstractFactoryBean {
    private List<X509Certificate> certificates;
    private List<X509CRL> x509crls;
    private Integer verifyDepth;

    protected Object createInstance() throws Exception {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (this.getCertificates() != null) {
            certs.addAll(this.getCertificates());
        }
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
        if (this.getCrls() != null) {
            crls.addAll(this.getCrls());
        }
        return new BasicPKIXValidationInformation(certs, crls, this.getVerifyDepth());
    }

    public Class getObjectType() {
        return PKIXValidationInformation.class;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public List<X509CRL> getCrls() {
        return this.x509crls;
    }

    public Integer getVerifyDepth() {
        return this.verifyDepth;
    }

    public void setCertificates(List<X509Certificate> certs) {
        this.certificates = certs;
    }

    public void setCrls(List<X509CRL> crls) {
        this.x509crls = crls;
    }

    public void setVerifyDepth(Integer newDepth) {
        this.verifyDepth = newDepth;
    }
}

