/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.AbstractResolutionPlugInBeanDefinitionParser;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class BaseAttributeDefinitionBeanDefinitionParser
extends AbstractResolutionPlugInBeanDefinitionParser {
    public static final QName ATTRIBUTE_ENCODER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "AttributeEncoder");
    private Logger log = LoggerFactory.getLogger(BaseAttributeDefinitionBeanDefinitionParser.class);

    @Override
    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        List<Element> displayDescriptions;
        String sourceAttributeId = pluginConfig.getAttributeNS(null, "sourceAttributeID");
        this.log.debug("Setting source attribute ID for attribute definition {} to: {}", (Object)pluginId, (Object)sourceAttributeId);
        pluginBuilder.addPropertyValue("sourceAttributeId", (Object)sourceAttributeId);
        List<Element> displayNames = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver", "DisplayName"));
        if (displayNames != null) {
            this.log.debug("Setting {} display names for attribute definition {}", (Object)displayNames.size(), (Object)pluginId);
            pluginBuilder.addPropertyValue("displayNames", this.processLocalizedElement(displayNames));
        }
        if ((displayDescriptions = pluginConfigChildren.get(new QName("urn:mace:shibboleth:2.0:resolver", "DisplayDescription"))) != null) {
            this.log.debug("Setting {} display descriptions for attribute definition {}", (Object)displayDescriptions.size(), (Object)pluginId);
            pluginBuilder.addPropertyValue("displayDescriptions", this.processLocalizedElement(displayDescriptions));
        }
        boolean dependencyOnly = false;
        if (pluginConfig.hasAttributeNS(null, "dependencyOnly")) {
            dependencyOnly = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "dependencyOnly"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attribute definition {} produces attributes that are only dependencies: {}", (Object)pluginId, (Object)dependencyOnly);
        }
        pluginBuilder.addPropertyValue("dependencyOnly", (Object)dependencyOnly);
        pluginBuilder.addPropertyValue("attributeEncoders", (Object)SpringConfigurationUtils.parseInnerCustomElements(pluginConfigChildren.get(ATTRIBUTE_ENCODER_ELEMENT_NAME), parserContext));
    }

    protected Map<Locale, String> processLocalizedElement(List<Element> elements) {
        HashMap<Locale, String> localizedString = new HashMap<Locale, String>(elements.size());
        for (Element element : elements) {
            localizedString.put(XMLHelper.getLanguage((Element)element), element.getTextContent());
        }
        return localizedString;
    }
}

