/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session.impl;

import edu.internet2.middleware.shibboleth.idp.session.AuthenticationMethodInformation;
import java.security.Principal;
import javax.security.auth.Subject;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class AuthenticationMethodInformationImpl
implements AuthenticationMethodInformation {
    private static final long serialVersionUID = -2108905664641155003L;
    private Subject authenticationSubject;
    private Principal authenticationPrincipal;
    private String authenticationMethod;
    private long authenticationInstant;
    private long authenticationDuration;
    private long expirationInstant;

    public AuthenticationMethodInformationImpl(Subject subject, Principal principal, String method, DateTime instant, long duration) {
        if (method == null || instant == null || duration < 0L) {
            throw new IllegalArgumentException("Authentication method, instant, and duration may not be null");
        }
        this.authenticationSubject = subject;
        this.authenticationPrincipal = principal;
        this.authenticationMethod = method;
        this.authenticationInstant = instant.toDateTime((Chronology)ISOChronology.getInstanceUTC()).getMillis();
        this.authenticationDuration = duration;
        this.expirationInstant = this.authenticationInstant + duration;
    }

    public synchronized Subject getAuthenticationSubject() {
        return this.authenticationSubject;
    }

    public synchronized Principal getAuthenticationPrincipal() {
        return this.authenticationPrincipal;
    }

    public synchronized String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public synchronized DateTime getAuthenticationInstant() {
        return new DateTime(this.authenticationInstant, (Chronology)ISOChronology.getInstanceUTC());
    }

    public synchronized long getAuthenticationDuration() {
        return this.authenticationDuration;
    }

    public synchronized boolean isExpired() {
        return new DateTime(this.expirationInstant, (Chronology)ISOChronology.getInstanceUTC()).isBeforeNow();
    }

    public synchronized int hashCode() {
        return this.authenticationMethod.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AuthenticationMethodInformation)) {
            return false;
        }
        AuthenticationMethodInformation amInfo = (AuthenticationMethodInformation)obj;
        return this.authenticationMethod.equals(amInfo.getAuthenticationMethod());
    }
}

