/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.config.profile.authn;

import edu.internet2.middleware.shibboleth.idp.config.profile.authn.AbstractLoginHandlerBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.idp.config.profile.authn.UsernamePasswordLoginHandlerFactoryBean;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class UsernamePasswordLoginHandlerBeanDefinitionParser
extends AbstractLoginHandlerBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:idp:profile-handler", "UsernamePassword");
    private final Logger log = LoggerFactory.getLogger(UsernamePasswordLoginHandlerBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return UsernamePasswordLoginHandlerFactoryBean.class;
    }

    protected void doParse(Element config, BeanDefinitionBuilder builder) {
        super.doParse(config, builder);
        if (config.hasAttributeNS(null, "authenticationServletURL")) {
            builder.addPropertyValue("authenticationServletURL", (Object)DatatypeHelper.safeTrim((String)config.getAttributeNS(null, "authenticationServletURL")));
        } else {
            builder.addPropertyValue("authenticationServletURL", (Object)"/Authn/UserPassword");
        }
        String jaasConfigurationURL = DatatypeHelper.safeTrim((String)config.getAttributeNS(null, "jaasConfigurationLocation"));
        this.log.debug("Setting JAAS configuration file to: {}", (Object)jaasConfigurationURL);
        System.setProperty("java.security.auth.login.config", jaasConfigurationURL);
    }
}

