/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.props;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyInvoker {
    protected static final Map<String, Map<String, Method[]>> PROPERTIES_CACHE = new HashMap<String, Map<String, Method[]>>();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Class<?> clazz;
    protected Map<String, Method[]> properties;

    protected void initialize(Class<?> c, String domain) {
        String cacheKey = c.getName() + "@" + domain;
        if (PROPERTIES_CACHE.containsKey(cacheKey)) {
            this.properties = PROPERTIES_CACHE.get(cacheKey);
        } else {
            this.properties = new HashMap<String, Method[]>();
            PROPERTIES_CACHE.put(cacheKey, this.properties);
            for (Method method : c.getMethods()) {
                Method[] m;
                String pName;
                String mName;
                if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
                    mName = method.getName().substring(3);
                    pName = domain + mName.substring(0, 1).toLowerCase() + mName.substring(1, mName.length());
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        m[1] = method;
                        this.properties.put(pName, m);
                        continue;
                    }
                    this.properties.put(pName, new Method[]{null, method});
                    continue;
                }
                if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                    mName = method.getName().substring(3);
                    pName = domain + mName.substring(0, 1).toLowerCase() + mName.substring(1, mName.length());
                    if (this.properties.containsKey(pName)) {
                        m = this.properties.get(pName);
                        m[0] = method;
                        this.properties.put(pName, m);
                        continue;
                    }
                    this.properties.put(pName, new Method[]{method, null});
                    continue;
                }
                if (!"initialize".equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                String pName2 = domain + method.getName();
                this.properties.put(pName2, new Method[]{method, method});
            }
        }
        this.clazz = c;
    }

    public void setProperty(Object object, String name, String value) {
        Method setter;
        Method getter;
        if (!this.clazz.isInstance(object)) {
            throw new IllegalArgumentException("Illegal attempt to set property for class " + this.clazz.getName() + " on object of type " + object.getClass().getName());
        }
        Method method = getter = this.properties.get(name) != null ? this.properties.get(name)[0] : null;
        if (getter == null) {
            throw new IllegalArgumentException("No getter method found for " + name + " on object " + this.clazz.getName());
        }
        Method method2 = setter = this.properties.get(name) != null ? this.properties.get(name)[1] : null;
        if (setter == null) {
            throw new IllegalArgumentException("No setter method found for " + name + " on object " + this.clazz.getName());
        }
        AbstractPropertyInvoker.invokeMethod(setter, object, this.convertValue(getter.getReturnType(), value));
    }

    protected abstract Object convertValue(Class<?> var1, String var2);

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Set<String> getProperties() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public static <T> T instantiateType(T type, String className) {
        try {
            return (T)AbstractPropertyInvoker.createClass(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class<?> createClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class '" + className + "'", e);
        }
    }

    public static Object invokeMethod(Method method, Object object, Object arg) {
        try {
            Object[] params = new Object[]{arg};
            if (arg == null && method.getParameterTypes().length == 0) {
                params = null;
            }
            return method.invoke(object, params);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

