/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap;

import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

public final class AttributesFactory {
    private AttributesFactory() {
    }

    public static Attributes createAttributes(String name) {
        return AttributesFactory.createAttributes(name, true);
    }

    public static Attributes createAttributes(String name, boolean ignoreCase) {
        return AttributesFactory.createAttributes(name, null, ignoreCase);
    }

    public static Attributes createAttributes(String name, Object value) {
        return AttributesFactory.createAttributes(name, value, true);
    }

    public static Attributes createAttributes(String name, Object value, boolean ignoreCase) {
        if (value == null) {
            return AttributesFactory.createAttributes(name, null, ignoreCase);
        }
        return AttributesFactory.createAttributes(name, new Object[]{value}, ignoreCase);
    }

    public static Attributes createAttributes(String name, Object[] values) {
        return AttributesFactory.createAttributes(name, values, true);
    }

    public static Attributes createAttributes(String name, Object[] values, boolean ignoreCase) {
        BasicAttributes attrs = new BasicAttributes(ignoreCase);
        attrs.put(AttributesFactory.createAttribute(name, values));
        return attrs;
    }

    public static Attribute createAttribute(String name) {
        return AttributesFactory.createAttribute(name, null);
    }

    public static Attribute createAttribute(String name, Object value) {
        if (value == null) {
            return AttributesFactory.createAttribute(name, null);
        }
        return AttributesFactory.createAttribute(name, new Object[]{value});
    }

    public static Attribute createAttribute(String name, Object[] values) {
        BasicAttribute attr = new BasicAttribute(name);
        if (values != null) {
            for (Object o : values) {
                attr.add(o);
            }
        }
        return attr;
    }
}

