/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDStore;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.sql.DataSource;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.SubjectQuery;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredIDDataConnector
extends BaseDataConnector {
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnector.class);
    private StoredIDStore pidStore;
    private String generatedAttribute;
    private String sourceAttribute;
    private byte[] salt;

    public StoredIDDataConnector(DataSource source, int queryTimeout, String generatedAttributeId, String sourceAttributeId, byte[] idSalt) {
        if (source == null) {
            throw new IllegalArgumentException("Data source may not be null");
        }
        this.pidStore = new StoredIDStore(source, queryTimeout);
        if (DatatypeHelper.isEmpty((String)generatedAttributeId)) {
            throw new IllegalArgumentException("Provided generated attribute ID must not be empty");
        }
        this.generatedAttribute = generatedAttributeId;
        if (DatatypeHelper.isEmpty((String)sourceAttributeId)) {
            throw new IllegalArgumentException("Provided source attribute ID must not be empty");
        }
        this.sourceAttribute = sourceAttributeId;
        if (idSalt.length < 16) {
            throw new IllegalArgumentException("Provided salt must be at least 16 bytes in size.");
        }
        this.salt = idSalt;
    }

    public StoredIDStore getStoredIDStore() {
        return this.pidStore;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSourceAttributeId() {
        return this.sourceAttribute;
    }

    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.getDependencyIds() == null || this.getDependencyIds().size() != 1) {
            this.log.error("Stored ID " + this.getId() + " data connectore requires exactly one dependency");
            throw new AttributeResolutionException("Computed ID " + this.getId() + " data connectore requires exactly one dependency");
        }
        try {
            this.pidStore.getActivePersistentIdEntry("1");
        }
        catch (SQLException e) {
            throw new AttributeResolutionException("Unable to connect to persistent ID store.");
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        LazyMap attributes = new LazyMap();
        String principalName = DatatypeHelper.safeTrimOrNullString((String)resolutionContext.getAttributeRequestContext().getPrincipalName());
        String localId = this.getLocalId(resolutionContext);
        if (localId == null) {
            this.log.debug("No user local ID available, skipping ID creation.");
            return attributes;
        }
        String localEntityId = DatatypeHelper.safeTrimOrNullString((String)resolutionContext.getAttributeRequestContext().getLocalEntityId());
        if (localEntityId == null) {
            this.log.debug("No local entity ID available, skipping ID creation.");
            return attributes;
        }
        String peerEntityId = this.getPeerEntityId(resolutionContext);
        if (peerEntityId == null) {
            this.log.debug("No peer entity ID available, skipping ID creation.");
            return attributes;
        }
        String persistentId = this.getStoredId(principalName, localEntityId, peerEntityId, localId);
        if (persistentId != null) {
            BasicAttribute attribute = new BasicAttribute();
            attribute.setId(this.getGeneratedAttributeId());
            attribute.getValues().add(persistentId);
            attributes.put(attribute.getId(), attribute);
        }
        return attributes;
    }

    protected String getStoredId(String principalName, String localEntityId, String peerEntityId, String localId) throws AttributeResolutionException {
        try {
            this.log.debug("Checking for existing, active, stored ID for principal '{}'", (Object)principalName);
            StoredIDStore.PersistentIdEntry idEntry = this.pidStore.getActivePersistentIdEntry(localEntityId, peerEntityId, localId);
            if (idEntry == null) {
                this.log.debug("No existing, active, stored ID, creating a new one for principal '{}'", (Object)principalName);
                idEntry = this.createPersistentId(principalName, localEntityId, peerEntityId, localId);
                this.pidStore.storePersistentIdEntry(idEntry);
                this.log.debug("Created stored ID '{}'", (Object)idEntry);
            } else {
                this.log.debug("Located existing stored ID {}", (Object)idEntry);
            }
            return idEntry.getPersistentId();
        }
        catch (SQLException e) {
            this.log.debug("Database error retrieving persistent identifier", (Throwable)e);
            throw new AttributeResolutionException("Database error retrieving persistent identifier", e);
        }
    }

    protected String getLocalId(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        Collection<Object> sourceIdValues = this.getValuesFromAllDependencies(resolutionContext, this.getSourceAttributeId());
        if (sourceIdValues == null || sourceIdValues.isEmpty()) {
            this.log.debug("Source attribute {} for connector {} provide no values.  No identifier will be generated.", (Object)this.getSourceAttributeId(), (Object)this.getId());
            return null;
        }
        if (sourceIdValues.size() > 1) {
            this.log.warn("Source attribute {} for connector {} has more than one value, only the first value is used", (Object)this.getSourceAttributeId(), (Object)this.getId());
        }
        return sourceIdValues.iterator().next().toString();
    }

    protected String getPeerEntityId(ShibbolethResolutionContext resolutionContext) {
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        String peerEntityId = null;
        this.log.debug("Determining if peer entity ID will be the SPNameQualifier from a SAML 2 authentication statement");
        SAMLObject inboundMessage = requestContext.getInboundSAMLMessage();
        if (inboundMessage instanceof AuthnRequest) {
            AuthnRequest authnRequest = (AuthnRequest)inboundMessage;
            if (authnRequest.getNameIDPolicy() != null) {
                peerEntityId = DatatypeHelper.safeTrimOrNullString((String)authnRequest.getNameIDPolicy().getSPNameQualifier());
                if (peerEntityId == null) {
                    this.log.debug("SAML 2 authentication request did not contain an SPNameQualifier within its NameIDPolicy");
                } else {
                    this.log.debug("SAML 2 authentication request contained an SPNameQualifier, within its NameIDPolicy.  Using that as peer entity ID");
                }
            } else {
                this.log.debug("SAML 2 authentication request did not contain a NameIDPolicy");
            }
        } else if (inboundMessage instanceof SubjectQuery) {
            SubjectQuery query = (SubjectQuery)inboundMessage;
            if (query.getSubject().getNameID().getSPNameQualifier() != null) {
                peerEntityId = DatatypeHelper.safeTrimOrNullString((String)query.getSubject().getNameID().getSPNameQualifier());
                if (peerEntityId == null) {
                    this.log.debug("SAML 2 subject query did not contain an SPNameQualifier within its NameID");
                } else {
                    this.log.debug("SAML 2 subject query contained an SPNameQualifier, within its NameID.  Using that as peer entity ID");
                }
            } else {
                this.log.debug("SAML 2 attribute query did not contain a SPNameQualifier");
            }
        } else {
            peerEntityId = requestContext.getInboundMessageIssuer();
        }
        if (peerEntityId == null) {
            this.log.debug("Determining if inbound message issuer is available for use as peer entity ID");
            peerEntityId = resolutionContext.getAttributeRequestContext().getInboundMessageIssuer();
        }
        return peerEntityId;
    }

    protected StoredIDStore.PersistentIdEntry createPersistentId(String principalName, String localEntityId, String peerEntityId, String localId) throws SQLException {
        String persistentId;
        StoredIDStore.PersistentIdEntry entry = new StoredIDStore.PersistentIdEntry(this.pidStore);
        entry.setLocalEntityId(localEntityId);
        entry.setPeerEntityId(peerEntityId);
        entry.setPrincipalName(principalName);
        entry.setLocalId(localId);
        int numberOfExistingEntries = this.pidStore.getNumberOfPersistentIdEntries(entry.getLocalEntityId(), entry.getPeerEntityId(), entry.getLocalId());
        if (numberOfExistingEntries == 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(entry.getPeerEntityId().getBytes());
                md.update((byte)33);
                md.update(localId.getBytes());
                md.update((byte)33);
                persistentId = Base64.encodeBytes((byte[])md.digest(this.salt));
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("JVM error, SHA-1 is not supported, unable to compute ID");
                throw new SQLException("SHA-1 is not supported, unable to compute ID");
            }
        } else {
            persistentId = UUID.randomUUID().toString();
        }
        while (this.pidStore.getPersistentIdEntry(persistentId, false) != null) {
            this.log.debug("Generated persistent ID was already assigned to another user, regenerating");
            persistentId = UUID.randomUUID().toString();
        }
        entry.setPersistentId(persistentId);
        entry.setCreationTime(new Timestamp(System.currentTimeMillis()));
        return entry;
    }
}

