/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Collection;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.NameID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2NameIDAttributeDefinition
extends BaseAttributeDefinition {
    private final SAMLObjectBuilder<NameID> nameIdBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(NameID.DEFAULT_ELEMENT_NAME);
    private String nameIdFormat;
    private String nameIdQualifier;
    private String nameIdSPQualifier;

    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String format) {
        this.nameIdFormat = format;
    }

    public String getNameIdQualifier() {
        return this.nameIdQualifier;
    }

    public void setNameIdQualifier(String qualifier) {
        this.nameIdQualifier = qualifier;
    }

    public String getNameIdSPQualifier() {
        return this.nameIdSPQualifier;
    }

    public void setNameIdSPQualifier(String qualifier) {
        this.nameIdSPQualifier = qualifier;
    }

    @Override
    protected BaseAttribute<?> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext);
        if (values != null && !values.isEmpty()) {
            for (Object value : values) {
                attribute.getValues().add(this.buildNameId(value.toString(), resolutionContext));
            }
        }
        return attribute;
    }

    protected NameID buildNameId(String nameIdValue, ShibbolethResolutionContext resolutionContext) {
        NameID nameId = (NameID)this.nameIdBuilder.buildObject();
        nameId.setValue(nameIdValue);
        if (this.nameIdFormat != null) {
            nameId.setFormat(this.nameIdFormat);
        }
        if (this.nameIdQualifier != null) {
            nameId.setNameQualifier(this.nameIdQualifier);
        } else {
            nameId.setNameQualifier(resolutionContext.getAttributeRequestContext().getLocalEntityId());
        }
        if (this.nameIdSPQualifier != null) {
            nameId.setSPNameQualifier(this.nameIdSPQualifier);
        } else {
            nameId.setSPNameQualifier(resolutionContext.getAttributeRequestContext().getInboundMessageIssuer());
        }
        return nameId;
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

