/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import org.opensaml.xml.util.DatatypeHelper;

public class IPRange {
    private int addressLength;
    private BitSet network;
    private BitSet mask;

    public IPRange(InetAddress networkAddress, int maskSize) {
        this(networkAddress.getAddress(), maskSize);
    }

    public IPRange(byte[] networkAddress, int maskSize) {
        this.addressLength = networkAddress.length * 8;
        if (this.addressLength != 32 && this.addressLength != 128) {
            throw new IllegalArgumentException("Network address was neither an IPv4 or IPv6 address");
        }
        this.network = this.toBitSet(networkAddress);
        this.mask = new BitSet(this.addressLength);
        this.mask.set(this.addressLength - maskSize, this.addressLength, true);
    }

    public static IPRange parseCIDRBlock(String cidrBlock) {
        String block = DatatypeHelper.safeTrimOrNullString((String)cidrBlock);
        if (block == null) {
            throw new IllegalArgumentException("CIDR block definition may not be null");
        }
        String[] blockParts = block.split("/");
        try {
            InetAddress networkAddress = InetAddress.getByName(blockParts[0]);
            int maskSize = Integer.parseInt(blockParts[1]);
            return new IPRange(networkAddress, maskSize);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP address");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid netmask size");
        }
    }

    public boolean contains(InetAddress address) {
        return this.contains(address.getAddress());
    }

    public boolean contains(byte[] address) {
        if (address.length * 8 != this.addressLength) {
            return false;
        }
        BitSet addrNetwork = this.toBitSet(address);
        addrNetwork.and(this.mask);
        return addrNetwork.equals(this.network);
    }

    protected BitSet toBitSet(byte[] bytes) {
        BitSet bits = new BitSet(bytes.length * 8);
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }
}

