/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.saml2.metadata.ContactPerson;
import org.opensaml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml2.metadata.EmailAddress;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.GivenName;
import org.opensaml.saml2.metadata.SurName;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContactTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -4000690571141490553L;
    private static Logger log = LoggerFactory.getLogger(ServiceContactTag.class);
    private ContactPersonTypeEnumeration contactType = ContactPersonTypeEnumeration.SUPPORT;
    private String contactName;

    public void setContactType(String type) {
        if (null == type || 0 == type.length()) {
            log.warn("no parameter provided to contactType");
            return;
        }
        if (type.equals(ContactPersonTypeEnumeration.ADMINISTRATIVE)) {
            this.contactType = ContactPersonTypeEnumeration.ADMINISTRATIVE;
        } else if (type.equals(ContactPersonTypeEnumeration.BILLING)) {
            this.contactType = ContactPersonTypeEnumeration.BILLING;
        } else if (type.equals(ContactPersonTypeEnumeration.OTHER)) {
            this.contactType = ContactPersonTypeEnumeration.OTHER;
        } else if (type.equals(ContactPersonTypeEnumeration.SUPPORT)) {
            this.contactType = ContactPersonTypeEnumeration.SUPPORT;
        } else if (type.equals(ContactPersonTypeEnumeration.TECHNICAL)) {
            this.contactType = ContactPersonTypeEnumeration.TECHNICAL;
        } else {
            log.warn("parameter provided to contactType:" + type + " is invalid");
            return;
        }
    }

    public void setName(String s) {
        this.contactName = s;
    }

    private String buildURL(String email, String name) {
        if (null != email) {
            if (log.isDebugEnabled()) {
                log.debug("constructing hyperlink from name \"" + name + "\" and email " + email);
            }
            return this.buildHyperLink(email, name);
        }
        Encoder esapiEncoder = ESAPI.encoder();
        if (log.isDebugEnabled()) {
            log.debug("no email found, using name \"" + name + "\" with no hyperlink");
        }
        if (null == name) {
            return name;
        }
        return esapiEncoder.encodeForHTML(name);
    }

    private String getStringFromContact(ContactPerson contact) {
        StringBuilder fullName = new StringBuilder();
        GivenName givenName = contact.getGivenName();
        SurName surName = contact.getSurName();
        List emails = contact.getEmailAddresses();
        String emailAddress = null;
        if (emails != null && !emails.isEmpty()) {
            emailAddress = ((EmailAddress)emails.get(0)).getAddress();
        }
        if (null != this.contactName) {
            return this.buildURL(emailAddress, this.contactName);
        }
        if (null != givenName) {
            fullName.append(givenName.getName()).append(" ");
        }
        if (null != surName) {
            fullName.append(surName.getName()).append(" ");
        }
        if (0 == fullName.length()) {
            if (null == emails) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("no names found, using email address as text");
            }
            fullName.append(emailAddress);
        }
        return this.buildURL(emailAddress, fullName.toString());
    }

    protected String getContactFromEntity() {
        EntityDescriptor sp = this.getSPEntityDescriptor();
        if (null == sp) {
            log.debug("No relying party, nothing to display");
            return null;
        }
        List contacts = sp.getContactPersons();
        if (null == contacts) {
            return null;
        }
        for (ContactPerson contact : contacts) {
            if (this.contactType != contact.getType()) continue;
            return this.getStringFromContact(contact);
        }
        return null;
    }

    public int doEndTag() throws JspException {
        String result = this.getContactFromEntity();
        try {
            if (null == result) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(result);
            }
        }
        catch (IOException e) {
            log.warn("Error generating Description");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

