/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.session;

import edu.internet2.middleware.shibboleth.common.session.SessionManager;
import edu.internet2.middleware.shibboleth.idp.session.Session;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class IdPSessionFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(IdPSessionFilter.class);
    private boolean consistentAddress;
    private SessionManager<Session> sessionManager;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        MDC.put((String)"JSESSIONID", (String)httpRequest.getSession().getId());
        MDC.put((String)"clientIP", (String)httpRequest.getRemoteAddr());
        Cookie sessionCookie = this.getIdPSessionCookie(httpRequest);
        Session idpSession = this.getUserSession(sessionCookie, httpRequest);
        if (idpSession != null) {
            this.log.trace("Updating IdP session activity time and adding session object to the request");
            idpSession.setLastActivityInstant(new DateTime());
            MDC.put((String)"idpSessionId", (String)idpSession.getSessionID());
            httpRequest.setAttribute("ShibbolethIdPSession", (Object)idpSession);
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String sessionManagerId = filterConfig.getInitParameter("sessionManagedId");
        if (DatatypeHelper.isEmpty((String)sessionManagerId)) {
            sessionManagerId = "shibboleth.SessionManager";
        }
        this.sessionManager = (SessionManager)filterConfig.getServletContext().getAttribute(sessionManagerId);
        String consistentAddressParam = filterConfig.getInitParameter("ensureConsistentClientAddress");
        this.consistentAddress = DatatypeHelper.isEmpty((String)consistentAddressParam) ? true : Boolean.parseBoolean(consistentAddressParam);
    }

    protected Cookie getIdPSessionCookie(HttpServletRequest httpRequest) {
        this.log.trace("Attempting to retrieve IdP session cookie.");
        Cookie[] requestCookies = httpRequest.getCookies();
        if (requestCookies != null) {
            for (Cookie requestCookie : requestCookies) {
                if (!DatatypeHelper.safeEquals((Object)requestCookie.getName(), (Object)"_idp_session")) continue;
                this.log.trace("Found IdP session cookie.");
                return requestCookie;
            }
        }
        return null;
    }

    protected Session getUserSession(Cookie sessionCookie, HttpServletRequest httpRequest) {
        if (sessionCookie == null || DatatypeHelper.isEmpty((String)sessionCookie.getValue())) {
            return null;
        }
        String cookieValue = HTTPTransportUtils.urlDecode((String)sessionCookie.getValue());
        String[] valueComponents = cookieValue.split("\\|");
        if (valueComponents.length != 3) {
            this.log.warn("IdP session cookie has an improperly formated value: {}", (Object)cookieValue);
            return null;
        }
        byte[] remoteAddressBytes = Base64.decode((String)valueComponents[0]);
        byte[] sessionIdBytes = Base64.decode((String)valueComponents[1]);
        byte[] signatureBytes = Base64.decode((String)valueComponents[2]);
        String sessionId = new String(sessionIdBytes);
        Session userSession = (Session)this.sessionManager.getSession(sessionId);
        if (userSession != null) {
            if (this.isCookieValid(httpRequest, remoteAddressBytes, sessionIdBytes, signatureBytes, userSession.getSessionSecret())) {
                return userSession;
            }
        } else {
            this.log.debug("No session associated with session ID {} - session must have timed out", (Object)valueComponents[1]);
        }
        return null;
    }

    protected boolean isCookieValid(HttpServletRequest httpRequest, byte[] remoteAddressBytes, byte[] sessionIdBytes, byte[] signatureBytes, byte[] sessionSecret) {
        if (this.consistentAddress) {
            String remoteAddress = new String(remoteAddressBytes);
            if (!httpRequest.getRemoteAddr().equals(remoteAddress)) {
                this.log.error("Client sent a cookie from address {} but the cookie was issued to address {}", (Object)httpRequest.getRemoteAddr(), (Object)remoteAddress);
                return false;
            }
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA");
            digester.update(sessionSecret);
            digester.update(remoteAddressBytes);
            digester.update(sessionIdBytes);
            if (!Arrays.equals(digester.digest(), signatureBytes)) {
                this.log.error("Session cookie has been tampered with, its signature no longer matches expected value");
                return false;
            }
        }
        catch (GeneralSecurityException e) {
            this.log.error("Unable to compute signature over session cookie material", (Throwable)e);
        }
        return true;
    }
}

