/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.rolling.helper.DatePatternToRegexUtil;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTokenConverter<E>
extends DynamicConverter<E>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "d";
    private String datePattern;
    private SimpleDateFormat sdf;

    @Override
    public void start() {
        this.datePattern = this.getFirstOption();
        if (this.datePattern == null) {
            this.datePattern = "yyyy-MM-dd";
        }
        this.sdf = new SimpleDateFormat(this.datePattern);
    }

    @Override
    public String convert(Date date) {
        return this.sdf.format(date);
    }

    @Override
    public String convert(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o instanceof Date) {
            return this.convert((Date)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " of type" + o.getClass().getName());
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public boolean isApplicable(Object o) {
        return o instanceof Date;
    }

    public String toRegex() {
        DatePatternToRegexUtil toRegex = new DatePatternToRegexUtil(this.datePattern);
        return toRegex.toRegex();
    }
}

