/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.util;

import edu.internet2.middleware.shibboleth.common.util.Base32;
import edu.internet2.middleware.shibboleth.common.util.DataExpiredException;
import edu.internet2.middleware.shibboleth.common.util.DataSealerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSealer {
    private static Logger log = LoggerFactory.getLogger((String)DataSealer.class.getName());
    private SecretKey cipherKey;
    private SecretKey macKey;
    private SecureRandom random;
    private String keystoreType = "JCEKS";
    private String keystorePath;
    private String keystorePassword;
    private String cipherKeyAlias;
    private String cipherKeyPassword;
    private String cipherAlgorithm = "AES/CBC/PKCS5Padding";
    private String macKeyAlias;
    private String macKeyPassword;
    private String macAlgorithm = "HmacSHA256";

    public void init() throws DataSealerException {
        try {
            if (this.cipherKey == null && (this.keystoreType == null || this.keystorePath == null || this.keystorePassword == null || this.cipherKeyAlias == null || this.cipherKeyPassword == null)) {
                throw new IllegalArgumentException("Missing a required configuration property.");
            }
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.loadKeys();
            this.testEncryption();
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught NoSuchAlgorithmException loading the java keystore.", e);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught IOException loading the java keystore.", e);
        }
    }

    public SecretKey getCipherKey() {
        return this.cipherKey;
    }

    public SecretKey getMacKey() {
        return this.macKey;
    }

    public SecureRandom getRandom() {
        return this.random;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getCipherKeyAlias() {
        return this.cipherKeyAlias;
    }

    public String getCipherKeyPassword() {
        return this.cipherKeyPassword;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getMacKeyAlias() {
        return this.macKeyAlias;
    }

    public String getMacKeyPassword() {
        return this.macKeyPassword;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setCipherKey(SecretKey key) {
        this.cipherKey = key;
    }

    public void setMacKey(SecretKey key) {
        this.macKey = key;
    }

    public void setRandom(SecureRandom r) {
        this.random = r;
    }

    public void setKeystoreType(String type) {
        this.keystoreType = type;
    }

    public void setKeystorePath(String path) {
        this.keystorePath = path;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setCipherKeyAlias(String alias) {
        this.cipherKeyAlias = alias;
    }

    public void setCipherKeyPassword(String password) {
        this.cipherKeyPassword = password;
    }

    public void setCipherAlgorithm(String alg) {
        this.cipherAlgorithm = alg;
    }

    public void setMacKeyAlias(String alias) {
        this.macKeyAlias = alias;
    }

    public void setMacKeyPassword(String password) {
        this.macKeyPassword = password;
    }

    public void setMacAlgorithm(String alg) {
        this.macAlgorithm = alg;
    }

    public String unwrap(String wrapped) throws DataSealerException {
        try {
            byte[] in = Base32.decode(wrapped);
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            int ivSize = cipher.getBlockSize();
            byte[] iv = new byte[ivSize];
            Mac mac = Mac.getInstance(this.macAlgorithm);
            mac.init(this.macKey);
            int macSize = mac.getMacLength();
            if (in.length < ivSize) {
                log.error("Wrapped data is malformed (not enough bytes).");
                throw new DataSealerException("Wrapped data is malformed (not enough bytes).");
            }
            System.arraycopy(in, 0, iv, 0, ivSize);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)this.cipherKey, ivSpec);
            byte[] encryptedHandle = new byte[in.length - iv.length];
            System.arraycopy(in, ivSize, encryptedHandle, 0, in.length - iv.length);
            byte[] decryptedBytes = cipher.doFinal(encryptedHandle);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(decryptedBytes);
            GZIPInputStream compressedData = new GZIPInputStream(byteStream);
            DataInputStream dataStream = new DataInputStream(compressedData);
            byte[] decodedMac = new byte[macSize];
            int bytesRead = dataStream.read(decodedMac);
            if (bytesRead != macSize) {
                log.error("Error parsing unwrapped data, unable to extract HMAC.");
                throw new DataSealerException("Error parsing unwrapped data, unable to extract HMAC.");
            }
            long decodedExpirationTime = dataStream.readLong();
            String decodedData = dataStream.readUTF();
            if (System.currentTimeMillis() > decodedExpirationTime) {
                log.info("Unwrapped data has expired.");
                throw new DataExpiredException("Unwrapped data has expired.");
            }
            byte[] generatedMac = DataSealer.getMAC(mac, decodedData, decodedExpirationTime);
            if (!Arrays.equals(decodedMac, generatedMac)) {
                log.warn("Unwrapped data failed integrity check.");
                throw new DataSealerException("Unwrapped data failed integrity check.");
            }
            log.debug("Unwrapped data verified.");
            return decodedData;
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught GeneralSecurityException unwrapping data.", e);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught IOException unwrapping data.", e);
        }
    }

    public String wrap(String data, long exp) throws DataSealerException {
        if (data == null) {
            throw new IllegalArgumentException("Data must be supplied for the wrapping operation.");
        }
        try {
            Mac mac = Mac.getInstance(this.macAlgorithm);
            mac.init(this.macKey);
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            byte[] iv = new byte[cipher.getBlockSize()];
            this.random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)this.cipherKey, ivSpec);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream compressedStream = new GZIPOutputStream(byteStream);
            DataOutputStream dataStream = new DataOutputStream(compressedStream);
            dataStream.write(DataSealer.getMAC(mac, data, exp));
            dataStream.writeLong(exp);
            dataStream.writeUTF(data);
            dataStream.flush();
            compressedStream.flush();
            compressedStream.finish();
            byteStream.flush();
            byte[] encryptedData = cipher.doFinal(byteStream.toByteArray());
            byte[] handleBytes = new byte[iv.length + encryptedData.length];
            System.arraycopy(iv, 0, handleBytes, 0, iv.length);
            System.arraycopy(encryptedData, 0, handleBytes, iv.length, encryptedData.length);
            return Base32.encode(handleBytes);
        }
        catch (KeyException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught KeyException wrapping data.", e);
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught GeneralSecurityException wrapping data.", e);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw new DataSealerException("Caught IOException wrapping data.", e);
        }
    }

    private void testEncryption() throws DataSealerException {
        byte[] code;
        String decrypted;
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            byte[] iv = new byte[cipher.getBlockSize()];
            this.random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            cipher.init(1, (Key)this.cipherKey, ivSpec);
            byte[] cipherText = cipher.doFinal("test".getBytes());
            cipher = Cipher.getInstance(this.cipherAlgorithm);
            cipher.init(2, (Key)this.cipherKey, ivSpec);
            decrypted = new String(cipher.doFinal(cipherText));
        }
        catch (GeneralSecurityException e) {
            log.error("Round trip encryption/decryption test unsuccessful: " + e);
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful.", e);
        }
        if (decrypted == null || !"test".equals(decrypted)) {
            log.error("Round trip encryption/decryption test unsuccessful. Decrypted text did not match.");
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful.");
        }
        try {
            Mac mac = Mac.getInstance(this.macAlgorithm);
            mac.init(this.macKey);
            mac.update("foo".getBytes());
            code = mac.doFinal();
        }
        catch (GeneralSecurityException e) {
            log.error("Message Authentication test unsuccessful: " + e);
            throw new DataSealerException("Message Authentication test unsuccessful.", e);
        }
        if (code == null) {
            log.error("Message Authentication test unsuccessful.");
            throw new DataSealerException("Message Authentication test unsuccessful.");
        }
    }

    private static byte[] getMAC(Mac mac, String data, long exp) {
        mac.update(DataSealer.getLongBytes(exp));
        mac.update(data.getBytes());
        return mac.doFinal();
    }

    private static byte[] getLongBytes(long longValue) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            dataStream.writeLong(longValue);
            dataStream.flush();
            byteStream.flush();
            return byteStream.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeys() throws GeneralSecurityException, IOException {
        if (this.cipherKey == null || this.macKey == null) {
            Key loadedKey;
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.keystorePath);
                ks.load(fis, this.keystorePassword.toCharArray());
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            if (this.cipherKey == null) {
                loadedKey = ks.getKey(this.cipherKeyAlias, this.cipherKeyPassword.toCharArray());
                if (!(loadedKey instanceof SecretKey)) {
                    log.error("Cipher key {} is not a symmetric key.", (Object)this.cipherKeyAlias);
                }
                this.cipherKey = (SecretKey)loadedKey;
            }
            if (this.macKey == null && this.macKeyAlias != null) {
                loadedKey = ks.getKey(this.macKeyAlias, this.macKeyPassword.toCharArray());
                if (!(loadedKey instanceof SecretKey)) {
                    log.error("MAC key {} is not a symmetric key.", (Object)this.macKeyAlias);
                }
                this.macKey = (SecretKey)loadedKey;
            } else if (this.macKey == null) {
                this.macKey = this.cipherKey;
            }
        }
    }
}

