/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.resource;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.resource.AbstractResourceBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.resource.SVNBasicAuthenticationManager;
import edu.internet2.middleware.shibboleth.common.resource.SVNResource;
import java.io.File;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.w3c.dom.Element;

public class SVNResourceBeanDefinitionParser
extends AbstractResourceBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:resource", "SVNResource");
    public static final String REPOSITORY_URL_ATTRIB_NAME = "repositoryURL";
    public static final String CTX_TIMEOUT_ATTRIB_NAME = "connectionTimeout";
    public static final String READ_TIMEOUT_ATTRIB_NAME = "readTimeout";
    public static final String WORKING_COPY_DIR_ATTRIB_NAME = "workingCopyDirectory";
    public static final String REVISION_ATTRIB_NAME = "revision";
    public static final String RESOURCE_FILE_ATTRIB_NAME = "resourceFile";
    public static final String USERNAME_ATTRIB_NAME = "username";
    public static final String PASSWORD_ATTRIB_NAME = "password";
    public static final String PROXY_HOST_ATTRIB_NAME = "proxyHost";
    public static final String PROXY_PORT_ATTRIB_NAME = "proxyPort";
    public static final String PROXY_USERNAME_ATTRIB_NAME = "proxyUsername";
    public static final String PROXY_PASSWORD_ATTRIB_NAME = "proxyPassword";
    public static final int DEFAULT_CTX_TIMEOUT = 3000;
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    public static final int DEFAULT_PROXY_PORT = 8080;
    private final Logger log = LoggerFactory.getLogger(SVNResourceBeanDefinitionParser.class);

    protected Class getBeanClass(Element arg0) {
        return SVNResource.class;
    }

    protected String resolveId(Element configElement, AbstractBeanDefinition beanDefinition, ParserContext parserContext) {
        return SVNResource.class.getName() + ":" + DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, REPOSITORY_URL_ATTRIB_NAME));
    }

    protected void doParse(Element configElement, ParserContext parserContext, BeanDefinitionBuilder builder) throws BeanCreationException {
        super.doParse(configElement, parserContext, builder);
        builder.addConstructorArgValue((Object)this.buildClientManager(configElement));
        builder.addConstructorArgValue((Object)this.getRespositoryUrl(configElement));
        builder.addConstructorArgValue((Object)this.getWorkingCopyDirectory(configElement));
        builder.addConstructorArgValue((Object)this.getRevision(configElement));
        builder.addConstructorArgValue((Object)this.getResourceFile(configElement));
        this.addResourceFilter(configElement, parserContext, builder);
    }

    protected SVNClientManager buildClientManager(Element configElement) {
        ArrayList<SVNAuthentication> authnMethods = new ArrayList<SVNAuthentication>();
        String username = this.getUsername(configElement);
        if (username != null) {
            authnMethods.add((SVNAuthentication)new SVNUserNameAuthentication(username, false));
            String password = this.getPassword(configElement);
            if (password != null) {
                authnMethods.add((SVNAuthentication)new SVNPasswordAuthentication(username, password, false));
            }
        }
        String proxyHost = this.getProxyHost(configElement);
        int proxyPort = this.getProxyPort(configElement);
        String proxyUser = this.getProxyUsername(configElement);
        String proxyPassword = this.getPassword(configElement);
        SVNBasicAuthenticationManager authnManager = proxyHost == null ? new SVNBasicAuthenticationManager(authnMethods) : new SVNBasicAuthenticationManager(authnMethods, proxyHost, proxyPort, proxyUser, proxyPassword);
        authnManager.setConnectionTimeout(this.getConnectionTimeout(configElement));
        authnManager.setReadTimeout(this.getReadTimeout(configElement));
        SVNClientManager clientManager = SVNClientManager.newInstance();
        clientManager.setAuthenticationManager((ISVNAuthenticationManager)authnManager);
        return clientManager;
    }

    protected SVNURL getRespositoryUrl(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, REPOSITORY_URL_ATTRIB_NAME)) {
            this.log.error("SVN resource definition missing required 'repositoryURL' attribute");
            throw new BeanCreationException("SVN resource definition missing required 'repositoryURL' attribute");
        }
        String repositoryUrl = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, REPOSITORY_URL_ATTRIB_NAME));
        try {
            return SVNURL.parseURIDecoded((String)repositoryUrl);
        }
        catch (SVNException e) {
            this.log.error("SVN remote repository URL " + repositoryUrl + " is not valid", (Throwable)e);
            throw new BeanCreationException("SVN remote repository URL " + repositoryUrl + " is not valid", (Throwable)e);
        }
    }

    protected int getConnectionTimeout(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, CTX_TIMEOUT_ATTRIB_NAME)) {
            return 3000;
        }
        return (int)SpringConfigurationUtils.parseDurationToMillis("connectionTimeout on SVN resource", configElement.getAttributeNS(null, CTX_TIMEOUT_ATTRIB_NAME), 0);
    }

    protected int getReadTimeout(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, READ_TIMEOUT_ATTRIB_NAME)) {
            return 5000;
        }
        return (int)SpringConfigurationUtils.parseDurationToMillis("readTimeout on SVN resource", configElement.getAttributeNS(null, CTX_TIMEOUT_ATTRIB_NAME), 0);
    }

    protected File getWorkingCopyDirectory(Element configElement) throws BeanCreationException {
        boolean created;
        if (!configElement.hasAttributeNS(null, WORKING_COPY_DIR_ATTRIB_NAME)) {
            this.log.error("SVN resource definition missing required 'workingCopyDirectory' attribute");
            throw new BeanCreationException("SVN resource definition missing required 'workingCopyDirectory' attribute");
        }
        File directory = new File(DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, WORKING_COPY_DIR_ATTRIB_NAME)));
        if (directory == null) {
            this.log.error("SVN working copy directory may not be null");
            throw new BeanCreationException("SVN working copy directory may not be null");
        }
        if (!directory.exists() && !(created = directory.mkdirs())) {
            this.log.error("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
            throw new BeanCreationException("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
        }
        if (!directory.isDirectory()) {
            this.log.error("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
            throw new BeanCreationException("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
        }
        if (!directory.canRead()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
            throw new BeanCreationException("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
        }
        if (!directory.canWrite()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
            throw new BeanCreationException("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
        }
        return directory;
    }

    protected long getRevision(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, REVISION_ATTRIB_NAME)) {
            return -1L;
        }
        try {
            return Long.parseLong(DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, WORKING_COPY_DIR_ATTRIB_NAME)));
        }
        catch (NumberFormatException e) {
            this.log.error("SVN resource definition attribute 'revision' contains an invalid number");
            throw new BeanCreationException("SVN resource definition attribute 'revision' contains an invalid number");
        }
    }

    protected String getResourceFile(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, RESOURCE_FILE_ATTRIB_NAME)) {
            this.log.error("SVN resource definition missing required 'resourceFile' attribute");
            throw new BeanCreationException("SVN resource definition missing required 'resourceFile' attribute");
        }
        String filename = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, RESOURCE_FILE_ATTRIB_NAME));
        if (filename == null) {
            this.log.error("SVN resource definition attribute 'resourceFile' may not be an empty string");
            throw new BeanCreationException("SVN resource definition attribute 'resourceFile' may not be an empty string");
        }
        return filename;
    }

    protected String getUsername(Element configElement) throws BeanCreationException {
        if (configElement.hasAttributeNS(null, USERNAME_ATTRIB_NAME)) {
            String username = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, USERNAME_ATTRIB_NAME));
            if (username == null) {
                this.log.error("SVN resource definition attribute 'username' may not be an empty string");
                throw new BeanCreationException("SVN resource definition attribute 'username' may not be an empty string");
            }
            return username;
        }
        return null;
    }

    protected String getPassword(Element configElement) throws BeanCreationException {
        if (configElement.hasAttributeNS(null, PASSWORD_ATTRIB_NAME)) {
            String password = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, PASSWORD_ATTRIB_NAME));
            if (password == null) {
                this.log.error("SVN resource definition attribute 'password' may not be an empty string");
                throw new BeanCreationException("SVN resource definition attribute 'password' may not be an empty string");
            }
            return password;
        }
        return null;
    }

    protected String getProxyHost(Element configElement) throws BeanCreationException {
        if (configElement.hasAttributeNS(null, PROXY_HOST_ATTRIB_NAME)) {
            String host = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, PROXY_HOST_ATTRIB_NAME));
            if (host == null) {
                this.log.error("SVN resource definition attribute 'proxyHost' may not be an empty string");
                throw new BeanCreationException("SVN resource definition attribute 'proxyHost' may not be an empty string");
            }
            return host;
        }
        return null;
    }

    protected int getProxyPort(Element configElement) throws BeanCreationException {
        if (!configElement.hasAttributeNS(null, PROXY_PORT_ATTRIB_NAME)) {
            return 8080;
        }
        String port = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, PROXY_PORT_ATTRIB_NAME));
        if (port == null) {
            this.log.error("SVN resource definition attribute 'proxyPort' may not be an empty string");
            throw new BeanCreationException("SVN resource definition attribute 'proxyPort' may not be an empty string");
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.log.error("SVN resource definition attribute 'proxyPort' contains an invalid number");
            throw new BeanCreationException("SVN resource definition attribute 'proxyPort' contains an invalid number");
        }
    }

    protected String getProxyUsername(Element configElement) throws BeanCreationException {
        if (configElement.hasAttributeNS(null, PROXY_USERNAME_ATTRIB_NAME)) {
            String username = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, PROXY_USERNAME_ATTRIB_NAME));
            if (username == null) {
                this.log.error("SVN resource definition attribute 'proxyUsername' may not be an empty string");
                throw new BeanCreationException("SVN resource definition attribute 'proxyUsername' may not be an empty string");
            }
            return username;
        }
        return null;
    }

    protected String getProxyPassword(Element configElement) throws BeanCreationException {
        if (configElement.hasAttributeNS(null, PROXY_PASSWORD_ATTRIB_NAME)) {
            String password = DatatypeHelper.safeTrimOrNullString((String)configElement.getAttributeNS(null, PROXY_PASSWORD_ATTRIB_NAME));
            if (password == null) {
                this.log.error("SVN resource definition attribute 'proxyPassword' may not be an empty string");
                throw new BeanCreationException("SVN resource definition attribute 'proxyPassword' may not be an empty string");
            }
            return password;
        }
        return null;
    }
}

