/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.metadata;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.metadata.AbstractMetadataProviderBeanDefinitionParser;
import javax.xml.datatype.Duration;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractReloadingMetadataProviderBeanDefinitionParser
extends AbstractMetadataProviderBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractReloadingMetadataProviderBeanDefinitionParser.class);

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String taskTimerRef = this.getTaskTimerRef(config);
        this.log.debug("Metadata provider using task timer: {}", (Object)taskTimerRef);
        builder.addConstructorArgReference(taskTimerRef);
        float refreshDelayFactor = this.getRefreshDelayFactor(config);
        this.log.debug("Metadata provider refresh delay factor: {}", (Object)Float.valueOf(refreshDelayFactor));
        builder.addPropertyValue("refreshDelayFactor", (Object)Float.valueOf(refreshDelayFactor));
        long minRefreshDelay = this.getMinRefreshDelay(config);
        this.log.debug("Metadata provider min refresh delay: {}ms", (Object)minRefreshDelay);
        builder.addPropertyValue("minRefreshDelay", (Object)minRefreshDelay);
        long maxRefreshDelay = this.getMaxRefreshDelay(config);
        this.log.debug("Metadata provider max refresh delay: {}ms", (Object)maxRefreshDelay);
        builder.addPropertyValue("maxRefreshDelay", (Object)maxRefreshDelay);
    }

    protected String getParserPoolRef(Element config) {
        String parserPoolRef = null;
        if (config.hasAttributeNS(null, "parerPoolRef")) {
            parserPoolRef = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "parserPoolRef"));
        }
        if (parserPoolRef == null) {
            parserPoolRef = "shibboleth.ParserPool";
        }
        return parserPoolRef;
    }

    protected String getTaskTimerRef(Element config) {
        String taskTimerRef = null;
        if (config.hasAttributeNS(null, "taskTimerRef")) {
            taskTimerRef = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "taskTimerRef"));
        }
        if (taskTimerRef == null) {
            taskTimerRef = "shibboleth.TaskTimer";
        }
        return taskTimerRef;
    }

    protected float getRefreshDelayFactor(Element config) {
        float delayFactor = 0.75f;
        if (config.hasAttributeNS(null, "refreshDelayFactor")) {
            String factorString = config.getAttributeNS(null, "refreshDelayFactor");
            try {
                delayFactor = Float.parseFloat(factorString);
            }
            catch (NumberFormatException e) {
                this.log.error("Metadata provider had invalid refreshDelayFactor value '{}', using default value", (Object)factorString);
            }
        }
        if ((double)delayFactor <= 0.0 || (double)delayFactor >= 1.0) {
            this.log.error("Metadata provider had invalid refreshDelayFactor value '{}', using default value", (Object)Float.valueOf(delayFactor));
            delayFactor = 0.75f;
        }
        return delayFactor;
    }

    protected long getMaxRefreshDelay(Element config) {
        int cacheDuration;
        long maxRefreshDelay = 14400000L;
        if (config.hasAttributeNS(null, "cacheDuration")) {
            cacheDuration = Integer.parseInt(config.getAttributeNS(null, "cacheDuration"));
            maxRefreshDelay = cacheDuration * 1000;
            this.log.warn("Metadata provider cacheDuration attribute is deprecated, use maxRefreshDelay=\"{}\" instead.", (Object)XMLHelper.getDataTypeFactory().newDuration(maxRefreshDelay).toString());
        }
        if (config.hasAttributeNS(null, "maxCacheDuration")) {
            cacheDuration = Integer.parseInt(config.getAttributeNS(null, "maxCacheDuration"));
            Duration duration = XMLHelper.getDataTypeFactory().newDuration(cacheDuration * 1000);
            this.log.warn("Metadata provider maxCacheDuration attribute is deprecated, use maxRefreshDelay=\"{}\" instead.", (Object)duration.toString());
        }
        if (config.hasAttributeNS(null, "maxRefreshDelay")) {
            String delayString = config.getAttributeNS(null, "maxRefreshDelay");
            try {
                maxRefreshDelay = SpringConfigurationUtils.parseDurationToMillis("maxRefreshDelay", delayString, 1);
            }
            catch (NumberFormatException e) {
                this.log.error("Metadata provider had invalid maxRefreshDelay value '{}', using default value", (Object)delayString);
            }
        }
        if (maxRefreshDelay <= 0L) {
            this.log.error("Metadata provider had invalid maxRefreshDelay value '{}', using default value", (Object)maxRefreshDelay);
            maxRefreshDelay = 14400000L;
        }
        return maxRefreshDelay;
    }

    protected long getMinRefreshDelay(Element config) {
        long minRefreshDelay = 300000L;
        if (config.hasAttributeNS(null, "minRefreshDelay")) {
            String delayString = config.getAttributeNS(null, "minRefreshDelay");
            try {
                minRefreshDelay = SpringConfigurationUtils.parseDurationToMillis("minRefreshDelay", delayString, 1);
            }
            catch (NumberFormatException e) {
                this.log.error("Metadata provider had invalid minRefreshDelay value '{}', using default value", (Object)delayString);
            }
        }
        if (minRefreshDelay <= 0L) {
            this.log.error("Metadata provider had invalid minRefreshDelay value '{}', using default value", (Object)minRefreshDelay);
            minRefreshDelay = 300000L;
        }
        return minRefreshDelay;
    }
}

