/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.LdapPoolStrategy;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorFactoryBean;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.handler.BinarySearchResultHandler;
import edu.vt.middleware.ldap.handler.CaseChangeSearchResultHandler;
import edu.vt.middleware.ldap.handler.ConnectionHandler;
import edu.vt.middleware.ldap.handler.EntryDnSearchResultHandler;
import edu.vt.middleware.ldap.handler.FqdnSearchResultHandler;
import edu.vt.middleware.ldap.handler.MergeSearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapValidator;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDataConnectorFactoryBean
extends BaseDataConnectorFactoryBean {
    private LdapPoolStrategy ldapPoolStrategy;
    private LdapConfig ldapConfig = new LdapConfig();
    private ConnectionHandler.ConnectionStrategy connStrategy;
    private Map<String, String> ldapProperties;
    private LdapValidator ldapValidator;
    private TemplateEngine templateEngine;
    private String filterTemplate;
    private List<String> returnAttributes;
    private X509Credential trustCredential;
    private X509Credential connectionCredential;
    private boolean mergeResults;
    private boolean noResultsIsError;
    private boolean lowercaseAttributeNames;
    private CacheManager cacheManager;
    private int maximumCachedElements;
    private long cacheElementTtl;

    protected Object createInstance() throws Exception {
        SSLContext ctx;
        ArrayList<Object> resultHandlers = new ArrayList<Object>();
        resultHandlers.add(new FqdnSearchResultHandler());
        resultHandlers.add(new EntryDnSearchResultHandler());
        if (this.mergeResults) {
            resultHandlers.add(new MergeSearchResultHandler());
        }
        if (this.lowercaseAttributeNames) {
            CaseChangeSearchResultHandler srh = new CaseChangeSearchResultHandler();
            srh.setAttributeNameCaseChange(CaseChangeSearchResultHandler.CaseChange.LOWER);
            resultHandlers.add(srh);
        }
        resultHandlers.add(new BinarySearchResultHandler());
        this.ldapConfig.setSearchResultHandlers(resultHandlers.toArray(new SearchResultHandler[resultHandlers.size()]));
        this.ldapConfig.getConnectionHandler().setConnectionStrategy(this.connStrategy);
        if (this.ldapProperties != null) {
            for (Map.Entry<String, String> entry : this.ldapProperties.entrySet()) {
                this.ldapConfig.setEnvironmentProperties(entry.getKey(), entry.getValue());
            }
        }
        if ((ctx = this.createSSLContext()) != null) {
            this.ldapConfig.setSslSocketFactory(ctx.getSocketFactory());
        }
        Cache resultsCache = null;
        if (this.cacheManager != null && (resultsCache = this.cacheManager.getCache(this.getPluginId())) == null) {
            long ttlInSeconds = this.cacheElementTtl / 1000L;
            resultsCache = new Cache(this.getPluginId(), this.maximumCachedElements, false, false, ttlInSeconds, ttlInSeconds);
            this.cacheManager.addCache(resultsCache);
        }
        DefaultLdapFactory ldapFactory = new DefaultLdapFactory(this.ldapConfig);
        if (this.ldapValidator != null) {
            ldapFactory.setLdapValidator(this.ldapValidator);
        }
        this.ldapPoolStrategy.setLdapFactory((LdapFactory<Ldap>)ldapFactory);
        this.ldapPoolStrategy.initialize();
        LdapDataConnector connector = new LdapDataConnector(this.ldapPoolStrategy, resultsCache);
        this.populateDataConnector(connector);
        connector.setNoResultsIsError(this.noResultsIsError);
        if (this.returnAttributes != null) {
            connector.setReturnAttributes(this.returnAttributes.toArray(new String[this.returnAttributes.size()]));
        }
        connector.registerTemplate(this.templateEngine, this.filterTemplate);
        return connector;
    }

    protected SSLContext createSSLContext() throws Exception {
        TrustManager[] sslTrustManagers = null;
        if (this.trustCredential != null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(null, null);
                for (X509Certificate c : this.trustCredential.getEntityCertificateChain()) {
                    keystore.setCertificateEntry("ldap_tls_trust_" + c.getSerialNumber(), c);
                }
                tmf.init(keystore);
                sslTrustManagers = tmf.getTrustManagers();
            }
            catch (GeneralSecurityException e) {
                this.logger.error((Object)"Error initializing trust managers", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)"Error initializing trust managers", (Throwable)e);
            }
        }
        KeyManager[] sslKeyManagers = null;
        if (this.connectionCredential != null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(null, null);
                keystore.setKeyEntry("ldap_tls_client_auth", this.connectionCredential.getPrivateKey(), "changeit".toCharArray(), this.connectionCredential.getEntityCertificateChain().toArray(new X509Certificate[0]));
                kmf.init(keystore, "changeit".toCharArray());
                sslKeyManagers = kmf.getKeyManagers();
            }
            catch (GeneralSecurityException e) {
                this.logger.error((Object)"Error initializing key managers", (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)"Error initializing key managers", (Throwable)e);
            }
        }
        SSLContext ctx = null;
        if (sslTrustManagers != null || sslKeyManagers != null) {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(sslKeyManagers, sslTrustManagers, null);
        }
        return ctx;
    }

    public LdapDataConnector.AUTHENTICATION_TYPE getAuthenticationType() {
        return LdapDataConnector.AUTHENTICATION_TYPE.getAuthenticationTypeByName(this.ldapConfig.getAuthtype());
    }

    public String getBaseDN() {
        return this.ldapConfig.getBaseDn();
    }

    public long getCacheElementTimeToLive() {
        return this.cacheElementTtl;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public X509Credential getConnectionCredential() {
        return this.connectionCredential;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public Map<String, String> getLdapProperties() {
        return this.ldapProperties;
    }

    public String getLdapUrl() {
        return this.ldapConfig.getLdapUrl();
    }

    public ConnectionHandler.ConnectionStrategy getConnectionStrategy() {
        return this.connStrategy;
    }

    public int getMaximumCachedElements() {
        return this.maximumCachedElements;
    }

    public int getMaxResultSize() {
        return (int)this.ldapConfig.getCountLimit();
    }

    public Class<?> getObjectType() {
        return LdapDataConnector.class;
    }

    public LdapPoolStrategy getPoolStrategy() {
        return this.ldapPoolStrategy;
    }

    public LdapValidator getPoolValidator() {
        return this.ldapValidator;
    }

    public String getPrincipal() {
        return this.ldapConfig.getBindDn();
    }

    public String getPrincipalCredential() {
        return (String)this.ldapConfig.getBindCredential();
    }

    public List<String> getReturnAttributes() {
        return this.returnAttributes;
    }

    public LdapConfig.SearchScope getSearchScope() {
        return this.ldapConfig.getSearchScope();
    }

    public int getSearchTimeLimit() {
        return this.ldapConfig.getTimeLimit();
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public X509Credential getTrustCredential() {
        return this.trustCredential;
    }

    public boolean getUseStartTLS() {
        return this.ldapConfig.isTlsEnabled();
    }

    public boolean isLowercaseAttributeNames() {
        return this.lowercaseAttributeNames;
    }

    public boolean isMergeResults() {
        return this.mergeResults;
    }

    public boolean isNoResultsIsError() {
        return this.noResultsIsError;
    }

    public void setAuthenticationType(LdapDataConnector.AUTHENTICATION_TYPE type) {
        this.ldapConfig.setAuthtype(type.getAuthTypeName());
    }

    public void setBaseDN(String dn) {
        String trimmedDN = DatatypeHelper.safeTrimOrNullString((String)dn);
        if (trimmedDN != null) {
            this.ldapConfig.setBaseDn(trimmedDN);
        } else {
            this.ldapConfig.setBaseDn("");
        }
    }

    public void setCacheElementTimeToLive(long ttl) {
        this.cacheElementTtl = ttl;
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public void setConnectionCredential(X509Credential credential) {
        this.connectionCredential = credential;
    }

    public void setFilterTemplate(String template) {
        this.filterTemplate = DatatypeHelper.safeTrimOrNullString((String)template);
    }

    public void setLdapProperties(Map<String, String> properties) {
        this.ldapProperties = properties;
    }

    public void setLdapUrl(String url) {
        this.ldapConfig.setLdapUrl(DatatypeHelper.safeTrimOrNullString((String)url));
    }

    public void setConnectionStrategy(ConnectionHandler.ConnectionStrategy strategy) {
        this.connStrategy = strategy;
    }

    public void setLowercaseAttributeNames(boolean lowercase) {
        this.lowercaseAttributeNames = lowercase;
    }

    public void setMaximumCachedElements(int max) {
        this.maximumCachedElements = max;
    }

    public void setMaxResultSize(int max) {
        this.ldapConfig.setCountLimit((long)max);
    }

    public void setMergeResults(boolean merge) {
        this.mergeResults = merge;
    }

    public void setNoResultsIsError(boolean isError) {
        this.noResultsIsError = isError;
    }

    public void setPoolStrategy(LdapPoolStrategy strategy) {
        this.ldapPoolStrategy = strategy;
    }

    public void setPoolValidator(LdapValidator validator) {
        this.ldapValidator = validator;
    }

    public void setPrincipal(String principalName) {
        this.ldapConfig.setBindDn(DatatypeHelper.safeTrimOrNullString((String)principalName));
    }

    public void setPrincipalCredential(String credential) {
        this.ldapConfig.setBindCredential((Object)DatatypeHelper.safeTrimOrNullString((String)credential));
    }

    public void setReturnAttributes(List<String> attributes) {
        this.returnAttributes = attributes;
    }

    public void setSearchScope(LdapConfig.SearchScope scope) {
        this.ldapConfig.setSearchScope(scope);
    }

    public void setSearchTimeLimit(int timeLimit) {
        this.ldapConfig.setTimeLimit(timeLimit);
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.templateEngine = engine;
    }

    public void setTrustCredential(X509Credential credential) {
        this.trustCredential = credential;
    }

    public void setUseStartTLS(boolean startTLS) {
        this.ldapConfig.setTls(startTLS);
    }
}

