/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.TransientIdEntry;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.security.NoSuchAlgorithmException;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.util.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientIdAttributeDefinition
extends BaseAttributeDefinition {
    private final Logger log = LoggerFactory.getLogger(TransientIdAttributeDefinition.class);
    private StorageService<String, TransientIdEntry> idStore;
    private String partition;
    private IdentifierGenerator idGenerator = new SecureRandomIdentifierGenerator();
    private int idSize;
    private long idLifetime;

    public TransientIdAttributeDefinition(StorageService<String, TransientIdEntry> store) throws NoSuchAlgorithmException {
        this.idStore = store;
        this.partition = "transientId";
        this.idSize = 16;
        this.idLifetime = 14400000L;
        this.idGenerator.generateIdentifier(this.idSize);
    }

    @Override
    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        String principalName = requestContext.getPrincipalName();
        if (principalName == null) {
            this.log.debug("Principal name for request {} was null, no attribute returned", (Object)requestContext.getInboundSAMLMessageId());
            return attribute;
        }
        this.log.debug("Building transient ID for request {}; outbound message issuer: {}, inbound message issuer: {}, principal identifer: {}", new Object[]{requestContext.getInboundSAMLMessageId(), requestContext.getOutboundMessageIssuer(), requestContext.getInboundMessageIssuer(), principalName});
        StringBuilder principalTokenIdBuilder = new StringBuilder();
        principalTokenIdBuilder.append(requestContext.getOutboundMessageIssuer()).append("!").append(requestContext.getInboundMessageIssuer()).append("!").append(principalName);
        String principalTokenId = principalTokenIdBuilder.toString();
        TransientIdEntry tokenEntry = (TransientIdEntry)((Object)this.idStore.get(this.partition, (Object)principalTokenId));
        if (tokenEntry == null || tokenEntry.isExpired()) {
            String token = this.idGenerator.generateIdentifier(this.idSize);
            tokenEntry = new TransientIdEntry(this.idLifetime, requestContext.getInboundMessageIssuer(), principalName, token);
            this.idStore.put(this.partition, (Object)token, (Object)tokenEntry);
            this.idStore.put(this.partition, (Object)principalTokenId, (Object)tokenEntry);
        }
        this.log.debug("Created transient ID {} for request {}", (Object)tokenEntry.getId(), (Object)requestContext.getInboundSAMLMessageId());
        attribute.getValues().add(tokenEntry.getId());
        return attribute;
    }

    public int getIdSize() {
        return this.idSize;
    }

    public void setIdSize(int size) {
        this.idSize = size;
    }

    public long getIdLifetime() {
        return this.idLifetime;
    }

    public void setTokenLiftetime(long lifetime) {
        this.idLifetime = lifetime;
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

