/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.ScopedAttributeValue;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Collection;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedAttributeDefinition
extends BaseAttributeDefinition {
    private String scope;

    public ScopedAttributeDefinition(String newScope) {
        this.scope = newScope;
    }

    @Override
    public BaseAttribute<ScopedAttributeValue> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute<ScopedAttributeValue> attribute = new BasicAttribute<ScopedAttributeValue>();
        attribute.setId(this.getId());
        Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext);
        if (values != null && !values.isEmpty()) {
            for (Object value : values) {
                String strValue;
                if (value == null || (strValue = DatatypeHelper.safeTrimOrNullString((String)value.toString())) == null) continue;
                attribute.getValues().add(new ScopedAttributeValue(strValue.toString(), this.scope));
            }
        }
        return attribute;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    public void validate() throws AttributeResolutionException {
    }
}

