/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    boolean firstCall = true;
    final SortedSet result = new TreeSet(COMPARE);
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    XmlAttrStack xmlattrStack = new XmlAttrStack();

    public Canonicalizer20010315(boolean bl) {
        super(bl);
    }

    Iterator handleAttributesSubtree(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        if (!element.hasAttributes() && !this.firstCall) {
            return null;
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getNamespaceURI();
            if (!XMLNS_URI.equals(string)) {
                sortedSet.add(attr);
                continue;
            }
            String string2 = attr.getLocalName();
            String string3 = attr.getValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3) || (node = nameSpaceSymbTable.addMappingAndRender(string2, string3, attr)) == null) continue;
            sortedSet.add(node);
            if (!C14nHelper.namespaceIsRelative(attr)) continue;
            Object[] objectArray = new Object[]{element.getTagName(), string2, attr.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
        if (this.firstCall) {
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            this.firstCall = false;
        }
        return sortedSet.iterator();
    }

    Iterator handleAttributes(Element element, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException {
        Node node;
        this.xmlattrStack.push(nameSpaceSymbTable.getLevel());
        boolean bl = this.isVisibleDO(element, nameSpaceSymbTable.getLevel()) == 1;
        NamedNodeMap namedNodeMap = null;
        int n = 0;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n = namedNodeMap.getLength();
        }
        SortedSet sortedSet = this.result;
        sortedSet.clear();
        for (int i = 0; i < n; ++i) {
            node = (Attr)namedNodeMap.item(i);
            String string = node.getNamespaceURI();
            if (!XMLNS_URI.equals(string)) {
                if (XML_LANG_URI.equals(string)) {
                    this.xmlattrStack.addXmlnsAttr((Attr)node);
                    continue;
                }
                if (!bl) continue;
                sortedSet.add(node);
                continue;
            }
            String string2 = node.getLocalName();
            String string3 = node.getValue();
            if ("xml".equals(string2) && XML_LANG_URI.equals(string3)) continue;
            if (this.isVisible(node)) {
                Node node2;
                if (!bl && nameSpaceSymbTable.removeMappingIfRender(string2) || (node2 = nameSpaceSymbTable.addMappingAndRender(string2, string3, (Attr)node)) == null) continue;
                sortedSet.add(node2);
                if (!C14nHelper.namespaceIsRelative((Attr)node)) continue;
                Object[] objectArray = new Object[]{element.getTagName(), string2, node.getNodeValue()};
                throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
            }
            if (bl && !"xmlns".equals(string2)) {
                nameSpaceSymbTable.removeMapping(string2);
                continue;
            }
            nameSpaceSymbTable.addMapping(string2, string3, (Attr)node);
        }
        if (bl) {
            Attr attr = element.getAttributeNodeNS(XMLNS_URI, "xmlns");
            node = null;
            if (attr == null) {
                node = nameSpaceSymbTable.getMapping("xmlns");
            } else if (!this.isVisible(attr)) {
                node = nameSpaceSymbTable.addMappingAndRender("xmlns", "", nullNode);
            }
            if (node != null) {
                sortedSet.add(node);
            }
            this.xmlattrStack.getXmlnsAttr(sortedSet);
            nameSpaceSymbTable.getUnrenderedNodes(sortedSet);
        }
        return sortedSet.iterator();
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node node, String string) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    void circumventBugIfNeeded(XMLSignatureInput xMLSignatureInput) throws CanonicalizationException, ParserConfigurationException, IOException, SAXException {
        if (!xMLSignatureInput.isNeedsToBeExpanded()) {
            return;
        }
        Document document = null;
        document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
        XMLUtils.circumventBug2650(document);
    }

    void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        if (!element.hasAttributes()) {
            return;
        }
        this.xmlattrStack.push(-1);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!XMLNS_URI.equals(attr.getNamespaceURI())) {
                if (!XML_LANG_URI.equals(attr.getNamespaceURI())) continue;
                this.xmlattrStack.addXmlnsAttr(attr);
                continue;
            }
            String string = attr.getLocalName();
            String string2 = attr.getNodeValue();
            if ("xml".equals(string) && XML_LANG_URI.equals(string2)) continue;
            nameSpaceSymbTable.addMapping(string, string2, attr);
        }
    }

    static class XmlAttrStack {
        int currentLevel = 0;
        int lastlevel = 0;
        XmlsStackElement cur;
        List levels = new ArrayList();

        XmlAttrStack() {
        }

        void push(int n) {
            this.currentLevel = n;
            if (this.currentLevel == -1) {
                return;
            }
            this.cur = null;
            while (this.lastlevel >= this.currentLevel) {
                this.levels.remove(this.levels.size() - 1);
                if (this.levels.size() == 0) {
                    this.lastlevel = 0;
                    return;
                }
                this.lastlevel = ((XmlsStackElement)this.levels.get((int)(this.levels.size() - 1))).level;
            }
        }

        void addXmlnsAttr(Attr attr) {
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.levels.add(this.cur);
                this.lastlevel = this.currentLevel;
            }
            this.cur.nodes.add(attr);
        }

        void getXmlnsAttr(Collection collection) {
            int n = this.levels.size() - 1;
            if (this.cur == null) {
                this.cur = new XmlsStackElement();
                this.cur.level = this.currentLevel;
                this.lastlevel = this.currentLevel;
                this.levels.add(this.cur);
            }
            boolean bl = false;
            XmlsStackElement xmlsStackElement = null;
            if (n == -1) {
                bl = true;
            } else {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                if (xmlsStackElement.rendered && xmlsStackElement.level + 1 == this.currentLevel) {
                    bl = true;
                }
            }
            if (bl) {
                collection.addAll(this.cur.nodes);
                this.cur.rendered = true;
                return;
            }
            HashMap<String, Attr> hashMap = new HashMap<String, Attr>();
            while (n >= 0) {
                xmlsStackElement = (XmlsStackElement)this.levels.get(n);
                Iterator iterator = xmlsStackElement.nodes.iterator();
                while (iterator.hasNext()) {
                    Attr attr = (Attr)iterator.next();
                    if (hashMap.containsKey(attr.getName())) continue;
                    hashMap.put(attr.getName(), attr);
                }
                --n;
            }
            this.cur.rendered = true;
            collection.addAll(hashMap.values());
        }

        static class XmlsStackElement {
            int level;
            boolean rendered = false;
            List nodes = new ArrayList();

            XmlsStackElement() {
            }
        }
    }
}

