/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.handler;

import edu.vt.middleware.ldap.handler.ResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultHandler<R, O>
implements ResultHandler<R, O> {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public List<O> process(SearchCriteria sc, NamingEnumeration<? extends R> en) throws NamingException {
        return this.process(sc, en, null);
    }

    @Override
    public List<O> process(SearchCriteria sc, NamingEnumeration<? extends R> en, Class<?>[] ignore) throws NamingException {
        ArrayList<O> results;
        block7: {
            results = new ArrayList<O>();
            if (en != null) {
                try {
                    while (en.hasMore()) {
                        O o = this.processResult(sc, en.next());
                        if (o == null) continue;
                        results.add(o);
                    }
                }
                catch (NamingException e) {
                    boolean ignoreException = false;
                    if (ignore != null && ignore.length > 0) {
                        for (Class<?> ne : ignore) {
                            if (!ne.isInstance(e)) continue;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)"Ignoring naming exception", (Throwable)e);
                            }
                            ignoreException = true;
                            break;
                        }
                    }
                    if (ignoreException) break block7;
                    throw e;
                }
            }
        }
        return results;
    }

    @Override
    public List<O> process(SearchCriteria sc, List<? extends R> l) throws NamingException {
        ArrayList<O> results = new ArrayList<O>();
        if (l != null) {
            for (R r : l) {
                O o = this.processResult(sc, r);
                if (o == null) continue;
                results.add(o);
            }
        }
        return results;
    }

    protected abstract O processResult(SearchCriteria var1, R var2) throws NamingException;
}

