/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential;

import java.util.List;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicKeyInfoGeneratorFactory
implements KeyInfoGeneratorFactory {
    private BasicOptions options = this.newOptions();

    @Override
    public Class<? extends Credential> getCredentialType() {
        return Credential.class;
    }

    @Override
    public boolean handles(Credential credential) {
        return true;
    }

    @Override
    public KeyInfoGenerator newInstance() {
        BasicOptions newOptions = this.options.clone();
        return new BasicKeyInfoGenerator(newOptions);
    }

    public boolean emitEntityIDAsKeyName() {
        return this.options.emitEntityIDAsKeyName;
    }

    public void setEmitEntityIDAsKeyName(boolean newValue) {
        this.options.emitEntityIDAsKeyName = newValue;
    }

    public boolean emitKeyNames() {
        return this.options.emitKeyNames;
    }

    public void setEmitKeyNames(boolean newValue) {
        this.options.emitKeyNames = newValue;
    }

    public boolean emitPublicKeyValue() {
        return this.options.emitPublicKeyValue;
    }

    public void setEmitPublicKeyValue(boolean newValue) {
        this.options.emitPublicKeyValue = newValue;
    }

    protected BasicOptions newOptions() {
        return new BasicOptions();
    }

    protected BasicOptions getOptions() {
        return this.options;
    }

    public class BasicKeyInfoGenerator
    implements KeyInfoGenerator {
        private BasicOptions options;
        private KeyInfoBuilder keyInfoBuilder;

        protected BasicKeyInfoGenerator(BasicOptions newOptions) {
            this.options = newOptions;
            this.keyInfoBuilder = (KeyInfoBuilder)Configuration.getBuilderFactory().getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
        }

        public KeyInfo generate(Credential credential) throws SecurityException {
            KeyInfo keyInfo = this.keyInfoBuilder.buildObject();
            this.processKeyNames(keyInfo, credential);
            this.processEntityID(keyInfo, credential);
            this.processPublicKey(keyInfo, credential);
            List<XMLObject> children = keyInfo.getOrderedChildren();
            if (children != null && children.size() > 0) {
                return keyInfo;
            }
            return null;
        }

        protected void processKeyNames(KeyInfo keyInfo, Credential credential) {
            if (this.options.emitKeyNames) {
                for (String keyNameValue : credential.getKeyNames()) {
                    if (DatatypeHelper.isEmpty(keyNameValue)) continue;
                    KeyInfoHelper.addKeyName(keyInfo, keyNameValue);
                }
            }
        }

        protected void processEntityID(KeyInfo keyInfo, Credential credential) {
            String keyNameValue;
            if (this.options.emitEntityIDAsKeyName && !DatatypeHelper.isEmpty(keyNameValue = credential.getEntityId())) {
                KeyInfoHelper.addKeyName(keyInfo, keyNameValue);
            }
        }

        protected void processPublicKey(KeyInfo keyInfo, Credential credential) {
            if (this.options.emitPublicKeyValue && credential.getPublicKey() != null) {
                KeyInfoHelper.addPublicKey(keyInfo, credential.getPublicKey());
            }
        }
    }

    protected class BasicOptions
    implements Cloneable {
        private boolean emitKeyNames;
        private boolean emitEntityIDAsKeyName;
        private boolean emitPublicKeyValue;

        protected BasicOptions() {
        }

        protected BasicOptions clone() {
            try {
                return (BasicOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

