/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDepthFilterEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private SVNDepth myRequestedDepth;
    private boolean myHasTarget;
    private NodeBaton myCurrentNodeBaton;

    private SVNDepthFilterEditor(SVNDepth depth, ISVNEditor delegate, boolean hasTarget) {
        this.myRequestedDepth = depth;
        this.myDelegate = delegate;
        this.myHasTarget = hasTarget;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.absentDir(path);
        }
    }

    public void absentFile(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.absentFile(path);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.DIR)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
            this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
            this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.changeDirProperty(name, value);
        }
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.changeFileProperty(path, name, value);
        }
    }

    public void closeDir() throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.closeDir();
        }
        this.myCurrentNodeBaton = this.myCurrentNodeBaton.myParentBaton;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return this.myDelegate.closeEdit();
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.closeFile(path, textChecksum);
        }
        this.myCurrentNodeBaton = this.myCurrentNodeBaton.myParentBaton;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            this.myDelegate.deleteEntry(path, revision);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.DIR)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
            this.myDelegate.openDir(path, revision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth + 1, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    public void openFile(String path, long revision) throws SVNException {
        NodeBaton childNodeBaton = null;
        if (this.myCurrentNodeBaton.canEdit(SVNNodeKind.FILE)) {
            childNodeBaton = new NodeBaton(false, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
            this.myDelegate.openFile(path, revision);
        } else {
            childNodeBaton = new NodeBaton(true, this.myCurrentNodeBaton.myDirDepth, this.myCurrentNodeBaton);
        }
        this.myCurrentNodeBaton = childNodeBaton;
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentNodeBaton = new NodeBaton(false, 1, null);
        this.myDelegate.openRoot(revision);
    }

    public void targetRevision(long revision) throws SVNException {
        this.myDelegate.targetRevision(revision);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.applyTextDelta(path, baseChecksum);
        }
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            return this.myDelegate.textDeltaChunk(path, diffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (!this.myCurrentNodeBaton.myIsFiltered) {
            this.myDelegate.textDeltaEnd(path);
        }
    }

    public static ISVNEditor getDepthFilterEditor(SVNDepth requestedDepth, ISVNEditor delegate, boolean hasTarget) {
        if (requestedDepth == SVNDepth.UNKNOWN || requestedDepth == SVNDepth.INFINITY) {
            return delegate;
        }
        return new SVNDepthFilterEditor(requestedDepth, delegate, hasTarget);
    }

    private class NodeBaton {
        boolean myIsFiltered;
        int myDirDepth;
        NodeBaton myParentBaton;

        public NodeBaton(boolean isFiltered, int depth, NodeBaton parent) {
            this.myIsFiltered = isFiltered;
            this.myDirDepth = depth;
            this.myParentBaton = parent;
        }

        public boolean canEdit(SVNNodeKind entryKind) throws SVNException {
            if (this.myIsFiltered) {
                return false;
            }
            int effectiveDepth = this.myDirDepth - (SVNDepthFilterEditor.this.myHasTarget ? 1 : 0);
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.EMPTY) {
                return effectiveDepth <= 0;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.FILES) {
                return effectiveDepth <= 0 || entryKind == SVNNodeKind.FILE && effectiveDepth == 1;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.IMMEDIATES) {
                return effectiveDepth <= 1;
            }
            if (SVNDepthFilterEditor.this.myRequestedDepth == SVNDepth.INFINITY) {
                return true;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "depth should be a valid constant");
            SVNErrorManager.error(err, SVNLogType.WC);
            return false;
        }
    }
}

