/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.io.File;
import org.tmatesoft.svn.core.internal.util.jna.ISVNCLibrary;
import org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNLinuxUtil {
    private static Memory ourSharedMemory;
    private static final boolean ourIsDashStat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNFileType getFileType(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = ourIsDashStat && SVNFileUtil.isBSD ? cLibrary._lstat(path, (Pointer)ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory));
                }
                if (rc < 0) {
                    if (file.exists() || file.isDirectory() || file.isFile()) {
                        return null;
                    }
                    return SVNFileType.NONE;
                }
                int mode = SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? ourSharedMemory.getShort((long)SVNLinuxUtil.getFileModeOffset()) : ourSharedMemory.getInt((long)SVNLinuxUtil.getFileModeOffset());
                int type = mode & 0xF000;
                if (type == 40960) {
                    return SVNFileType.SYMLINK;
                }
                if (type == 16384) {
                    return SVNFileType.DIRECTORY;
                }
                if (type == 32768) {
                    return SVNFileType.FILE;
                }
                if (file.exists() || file.isDirectory() || file.isFile()) {
                    return null;
                }
                return SVNFileType.NONE;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean isExecutable(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = ourIsDashStat && SVNFileUtil.isBSD ? cLibrary._lstat(path, (Pointer)ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory));
                }
                if (rc < 0) {
                    return null;
                }
                int mode = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileModeOffset());
                int fuid = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileUserIDOffset());
                int fgid = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileGroupIDOffset());
                int access = mode & 0x1FF;
                int mask = 73;
                mask = JNALibraryLoader.getUID() == fuid ? 64 : (JNALibraryLoader.getGID() == fgid ? 8 : 1);
                return (access & mask) != 0;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinkTarget(File file) {
        if (file == null || ourSharedMemory == null) {
            return null;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return null;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = cLibrary.readlink(path, (Pointer)ourSharedMemory, 1024);
                }
                if (rc <= 0) {
                    return null;
                }
                byte[] buffer = new byte[rc];
                ourSharedMemory.read(0L, buffer, 0, rc);
                return new String(buffer, 0, rc);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setExecutable(File file, boolean set) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = ourIsDashStat && SVNFileUtil.isBSD ? cLibrary._lstat(path, (Pointer)ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory));
                }
                if (rc < 0) {
                    return false;
                }
                int mode = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileModeOffset());
                int access = mode & 0x1FF;
                int mask = 0;
                if ((access & 0x100) != 0) {
                    mask |= 0x40;
                }
                if ((access & 0x20) != 0) {
                    mask |= 8;
                }
                if ((access & 4) != 0) {
                    mask |= 1;
                }
                if (mask == 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary2 = cLibrary;
                synchronized (iSVNCLibrary2) {
                    rc = cLibrary.chmod(path, set ? mask | access : mask ^ access);
                }
                return rc >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setWritable(File file) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = ourIsDashStat && SVNFileUtil.isBSD ? cLibrary._lstat(path, (Pointer)ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? cLibrary.lstat(path, (Pointer)ourSharedMemory) : cLibrary.__lxstat64(0, path, (Pointer)ourSharedMemory));
                }
                if (rc < 0) {
                    return false;
                }
                int mode = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileModeOffset());
                int access = mode & 0x1FF;
                int mask = 0;
                if ((access & 0x100) != 0) {
                    mask |= 0x80;
                }
                if ((access & 0x20) != 0) {
                    mask |= 0x10;
                }
                if ((access & 4) != 0) {
                    mask |= 2;
                }
                if (mask == 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary2 = cLibrary;
                synchronized (iSVNCLibrary2) {
                    rc = cLibrary.chmod(path, mask | access);
                }
                return rc >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setSGID(File file) {
        if (file == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            Memory memory = ourSharedMemory;
            synchronized (memory) {
                int mask;
                int rc;
                ourSharedMemory.clear();
                ISVNCLibrary iSVNCLibrary = cLibrary;
                synchronized (iSVNCLibrary) {
                    rc = ourIsDashStat && SVNFileUtil.isBSD ? cLibrary._stat(path, (Pointer)ourSharedMemory) : (SVNFileUtil.isOSX || SVNFileUtil.isBSD || SVNFileUtil.isSolaris ? cLibrary.stat(path, (Pointer)ourSharedMemory) : cLibrary.__xstat64(0, path, (Pointer)ourSharedMemory));
                }
                if (rc < 0) {
                    return false;
                }
                int mode = ourSharedMemory.getInt((long)SVNLinuxUtil.getFileModeOffset());
                int access = mode & 0xFFF;
                if ((access & (mask = 1024)) != 0) {
                    return false;
                }
                ISVNCLibrary iSVNCLibrary2 = cLibrary;
                synchronized (iSVNCLibrary2) {
                    rc = cLibrary.chmod(path, mask | access);
                }
                return rc >= 0;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSymlink(File file, String linkName) {
        if (file == null || linkName == null || ourSharedMemory == null) {
            return false;
        }
        String path = file.getAbsolutePath();
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            int rc;
            ISVNCLibrary cLibrary = JNALibraryLoader.getCLibrary();
            if (cLibrary == null) {
                return false;
            }
            ISVNCLibrary iSVNCLibrary = cLibrary;
            synchronized (iSVNCLibrary) {
                rc = cLibrary.symlink(linkName, path);
            }
            return rc >= 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static int getFileModeOffset() {
        if (SVNFileUtil.isLinux && SVNFileUtil.is64Bit) {
            return 24;
        }
        if (SVNFileUtil.isLinux && SVNFileUtil.is32Bit) {
            return 16;
        }
        if (SVNFileUtil.isOSX) {
            return 8;
        }
        if (SVNFileUtil.isSolaris) {
            return 20;
        }
        if (SVNFileUtil.isBSD) {
            return 8;
        }
        return 16;
    }

    private static int getFileUserIDOffset() {
        int modeOffset = SVNLinuxUtil.getFileModeOffset();
        if (SVNFileUtil.isLinux && SVNFileUtil.is64Bit) {
            return modeOffset + 4;
        }
        if (SVNFileUtil.isLinux && SVNFileUtil.is32Bit) {
            return modeOffset + 8;
        }
        if (SVNFileUtil.isOSX) {
            return modeOffset + 4;
        }
        if (SVNFileUtil.isSolaris) {
            return modeOffset + 8;
        }
        if (SVNFileUtil.isBSD) {
            return modeOffset + 4;
        }
        return modeOffset + 8;
    }

    private static int getFileGroupIDOffset() {
        return SVNLinuxUtil.getFileUserIDOffset() + 4;
    }

    static {
        ourIsDashStat = Boolean.getBoolean("svnkit.jna.dash_stat");
        try {
            ourSharedMemory = new Memory(1024L);
        }
        catch (Throwable th) {
            ourSharedMemory = null;
        }
    }
}

