/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.time.DateTime;
import org.opensaml.util.resource.AbstractFilteredResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;

public class SVNResource
extends AbstractFilteredResource {
    private final Logger log = LoggerFactory.getLogger(SVNResource.class);
    private final SVNClientManager clientManager;
    private SVNURL remoteRepository;
    private File workingCopyDirectory;
    private SVNRevision retrievalRevision;
    private String resourceFileName;
    private DateTime lastModified;

    public SVNResource(SVNClientManager svnClientMgr, SVNURL repositoryUrl, File workingCopy, long workingRevision, String resourceFile) throws ResourceException {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (svnClientMgr == null) {
            this.log.error("SVN client manager may not be null");
            throw new IllegalArgumentException("SVN client manager may not be null");
        }
        this.clientManager = svnClientMgr;
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("SVN repository URL may not be null");
        }
        this.remoteRepository = repositoryUrl;
        try {
            this.checkWorkingCopyDirectory(workingCopy);
            this.workingCopyDirectory = workingCopy;
        }
        catch (ResourceException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.retrievalRevision = workingRevision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)workingRevision);
        this.resourceFileName = DatatypeHelper.safeTrimOrNullString((String)resourceFile);
        if (this.resourceFileName == null) {
            this.log.error("SVN working copy resource file name may not be null or empty");
            throw new IllegalArgumentException("SVN working copy resource file name may not be null or empty");
        }
        this.checkoutOrUpdateResource();
        if (!this.getResourceFile().exists()) {
            this.log.error("Resource file " + resourceFile + " does not exist in SVN working copy directory " + workingCopy.getAbsolutePath());
            throw new ResourceException("Resource file " + resourceFile + " does not exist in SVN working copy directory " + workingCopy.getAbsolutePath());
        }
    }

    public boolean exists() throws ResourceException {
        return this.getResourceFile().exists();
    }

    public InputStream getInputStream() throws ResourceException {
        this.checkoutOrUpdateResource();
        try {
            return this.applyFilter(new FileInputStream(this.getResourceFile()));
        }
        catch (IOException e) {
            String erroMsg = "Unable to read resource file " + this.resourceFileName + " from local working copy " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(erroMsg, (Throwable)e);
            throw new ResourceException(erroMsg, (Exception)e);
        }
    }

    public DateTime getLastModifiedTime() throws ResourceException {
        this.checkoutOrUpdateResource();
        return this.lastModified;
    }

    public String getLocation() {
        return this.remoteRepository.toDecodedString() + "/" + this.resourceFileName;
    }

    protected File getResourceFile() throws ResourceException {
        return new File(this.workingCopyDirectory, this.resourceFileName);
    }

    protected void checkWorkingCopyDirectory(File directory) throws ResourceException {
        boolean created;
        if (directory == null) {
            this.log.error("SVN working copy directory may not be null");
            throw new ResourceException("SVN working copy directory may not be null");
        }
        if (!directory.exists() && !(created = directory.mkdirs())) {
            this.log.error("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
            throw new ResourceException("SVN working copy direction " + directory.getAbsolutePath() + " does not exist and could not be created");
        }
        if (!directory.isDirectory()) {
            this.log.error("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
            throw new ResourceException("SVN working copy location " + directory.getAbsolutePath() + " is not a directory");
        }
        if (!directory.canRead()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
            throw new ResourceException("SVN working copy directory " + directory.getAbsolutePath() + " can not be read by this process");
        }
        if (!directory.canWrite()) {
            this.log.error("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
            throw new ResourceException("SVN working copy directory " + directory.getAbsolutePath() + " can not be written to by this process");
        }
    }

    protected void checkoutOrUpdateResource() throws ResourceException {
        SVNRevision newRevision;
        this.log.debug("checking out or updating working copy");
        if (!this.workingCopyDirectoryExists()) {
            this.log.debug("working copy does not yet exist, checking it out");
            newRevision = this.checkoutResourceDirectory();
        } else {
            if (this.retrievalRevision != SVNRevision.HEAD) {
                this.log.debug("Working copy exists and version is pegged at {}, no need to update", (Object)this.retrievalRevision.toString());
                return;
            }
            this.log.debug("Working copy exists, updating to latest version.");
            newRevision = this.updateResourceDirectory();
        }
        this.log.debug("Determing last modification date of revision {}", (Object)newRevision.getNumber());
        this.lastModified = this.getLastModificationForRevision(newRevision);
    }

    private boolean workingCopyDirectoryExists() {
        File svnMetadataDir = new File(this.workingCopyDirectory, ".svn");
        return svnMetadataDir.exists();
    }

    private SVNRevision checkoutResourceDirectory() throws ResourceException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doCheckout(this.remoteRepository, this.workingCopyDirectory, this.retrievalRevision, this.retrievalRevision, SVNDepth.INFINITY, true);
            this.log.debug("Checked out revision {} from remote repository {} and stored it in local working directory {}", new Object[]{newRevision, this.remoteRepository.toDecodedString(), this.workingCopyDirectory.getAbsolutePath()});
            return SVNRevision.create((long)newRevision);
        }
        catch (SVNException e) {
            String errMsg = "Unable to check out revsion " + this.retrievalRevision.toString() + " from remote repository " + this.remoteRepository.toDecodedString() + " to local working directory " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new ResourceException(errMsg, (Exception)((Object)e));
        }
    }

    private SVNRevision updateResourceDirectory() throws ResourceException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doUpdate(this.workingCopyDirectory, this.retrievalRevision, SVNDepth.INFINITY, true, true);
            this.log.debug("Updated local working directory {} to revision {} from remote repository {}", new Object[]{this.workingCopyDirectory.getAbsolutePath(), newRevision, this.remoteRepository.toDecodedString()});
            return SVNRevision.create((long)newRevision);
        }
        catch (SVNException e) {
            String errMsg = "Unable to update working copy of resoure " + this.remoteRepository.toDecodedString() + " in working copy " + this.workingCopyDirectory.getAbsolutePath() + " to revsion " + this.retrievalRevision.toString();
            this.log.error(errMsg, (Throwable)e);
            throw new ResourceException(errMsg, (Exception)((Object)e));
        }
    }

    private DateTime getLastModificationForRevision(SVNRevision revision) throws ResourceException {
        try {
            SVNStatusHandler handler = new SVNStatusHandler();
            this.clientManager.getStatusClient().doStatus(this.getResourceFile(), revision, SVNDepth.INFINITY, true, true, false, false, (ISVNStatusHandler)handler, null);
            SVNStatus status = handler.getStatus();
            if (status.getRemoteRevision() == null) {
                return new DateTime((Object)status.getCommittedDate());
            }
            return new DateTime((Object)status.getRemoteDate());
        }
        catch (SVNException e) {
            String errMsg = "Unable to check status of resource " + this.resourceFileName + " within working directory " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new ResourceException(errMsg, (Exception)((Object)e));
        }
    }

    private class SVNStatusHandler
    implements ISVNStatusHandler {
        private SVNStatus status;

        private SVNStatusHandler() {
        }

        public SVNStatus getStatus() {
            return this.status;
        }

        public void handleStatus(SVNStatus currentStatus) throws SVNException {
            this.status = currentStatus;
        }
    }
}

