/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractBasicCredentialBeanDefinitionParser;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.springframework.beans.FatalBeanException;

public class FilesystemBasicCredentialBeanDefinitionParser
extends AbstractBasicCredentialBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:security", "BasicFilesystem");

    protected byte[] getEncodedPrivateKey(String keyConfigContent) {
        try {
            FileInputStream ins = new FileInputStream(keyConfigContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read private key from file " + keyConfigContent, (Throwable)e);
        }
    }

    protected byte[] getEncodedSecretKey(String keyConfigContent) {
        try {
            FileInputStream ins = new FileInputStream(keyConfigContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read secret key from file " + keyConfigContent, (Throwable)e);
        }
    }

    protected byte[] getEncodedPublicKey(String keyConfigContent) {
        try {
            FileInputStream ins = new FileInputStream(keyConfigContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read public key from file " + keyConfigContent, (Throwable)e);
        }
    }
}

