/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.security.ChainingSignatureTrustEngineFactoryBean;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChainingSignatureTrustEngineBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:security", "SignatureChaining");
    private static final QName TRUST_ENGINE_NAME = new QName("urn:mace:shibboleth:2.0:security", "TrustEngine");
    private static final QName TRUST_ENGINE_REF_NAME = new QName("urn:mace:shibboleth:2.0:security", "TrustEngineRef");
    private final Logger log = LoggerFactory.getLogger(ChainingSignatureTrustEngineBeanDefinitionParser.class);

    protected Class getBeanClass(Element element) {
        return ChainingSignatureTrustEngineFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.log.info("Parsing configuration for {} trust engine with id: {}", (Object)XMLHelper.getXSIType((Element)element).getLocalPart(), (Object)element.getAttributeNS(null, "id"));
        ManagedList managedChain = new ManagedList();
        Element child = XMLHelper.getFirstChildElement((Node)element);
        while (child != null) {
            QName childName = XMLHelper.getNodeQName((Node)child);
            if (TRUST_ENGINE_NAME.equals(childName)) {
                this.log.debug("Parsing chain trust engine member {}", (Object)element.getAttributeNS(null, "id"));
                managedChain.add((Object)SpringConfigurationUtils.parseCustomElement(child, parserContext));
            } else if (TRUST_ENGINE_REF_NAME.equals(childName)) {
                this.log.debug("Parsing chain trust engine member reference {}", (Object)element.getAttributeNS(null, "ref"));
                managedChain.add((Object)SpringConfigurationUtils.parseCustomElementReference(child, "ref", parserContext));
            } else {
                this.log.error("Unsupported child element of chaining trust engine '{}' encountered with name: {}", (Object)element.getAttributeNS(null, "id"), (Object)childName);
                throw new FatalBeanException("Unsupported child element of chaining trust engine encountered");
            }
            child = XMLHelper.getNextSiblingElement((Node)child);
        }
        builder.addPropertyValue("chain", (Object)managedChain);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return DatatypeHelper.safeTrim((String)element.getAttributeNS(null, "id"));
    }
}

