/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import java.security.KeyException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCredentialBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractCredentialBeanDefinitionParser.class);

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return element.getAttributeNS(null, "id");
    }

    protected void parseAttributes(Element element, BeanDefinitionBuilder builder) {
        String usage = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "usage"));
        if (usage != null) {
            builder.addPropertyValue("usageType", (Object)UsageType.valueOf((String)usage.toUpperCase()));
        } else {
            builder.addPropertyValue("usageType", (Object)UsageType.UNSPECIFIED);
        }
        String entityID = DatatypeHelper.safeTrimOrNullString((String)element.getAttributeNS(null, "entityID"));
        if (entityID != null) {
            builder.addPropertyValue("entityID", (Object)entityID);
        }
    }

    protected void parseCommon(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        this.parseKeyNames(configChildren, builder);
    }

    protected void parseKeyNames(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        this.log.debug("Parsing credential key names");
        List<Element> keyNameElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "KeyName"));
        if (keyNameElems == null || keyNameElems.isEmpty()) {
            return;
        }
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Element keyNameElem : keyNameElems) {
            String keyName = DatatypeHelper.safeTrimOrNullString((String)keyNameElem.getTextContent());
            if (keyName == null) continue;
            keyNames.add(keyName);
        }
        builder.addPropertyValue("keyNames", keyNames);
    }

    protected void parsePrivateKey(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder) {
        List<Element> keyElems = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "PrivateKey"));
        if (keyElems == null || keyElems.isEmpty()) {
            return;
        }
        this.log.debug("Parsing credential private key");
        Element privKeyElem = keyElems.get(0);
        byte[] encodedKey = this.getEncodedPrivateKey(DatatypeHelper.safeTrimOrNullString((String)privKeyElem.getTextContent()));
        String keyPassword = DatatypeHelper.safeTrimOrNullString((String)privKeyElem.getAttributeNS(null, "password"));
        char[] keyPasswordCharArray = null;
        if (keyPassword != null) {
            keyPasswordCharArray = keyPassword.toCharArray();
        }
        try {
            PrivateKey privKey = SecurityHelper.decodePrivateKey((byte[])encodedKey, (char[])keyPasswordCharArray);
            builder.addPropertyValue("privateKey", (Object)privKey);
        }
        catch (KeyException e) {
            throw new FatalBeanException("Unable to create credential, unable to parse private key", (Throwable)e);
        }
    }

    protected abstract byte[] getEncodedPrivateKey(String var1);
}

