/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.relyingparty;

import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.relyingparty.RelyingPartyConfigurationBeanDefinitionParser;
import edu.internet2.middleware.shibboleth.common.config.relyingparty.RelyingPartyGroup;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.XMLHelper;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelyingPartyGroupBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:relying-party", "RelyingPartyGroup");

    protected Class getBeanClass(Element element) {
        return RelyingPartyGroup.class;
    }

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Map configChildren = XMLHelper.getChildElements((Element)config);
        List mds = (List)configChildren.get(new QName("urn:mace:shibboleth:2.0:metadata", "MetadataProvider"));
        if (mds != null && mds.size() > 0) {
            Element mdConfigElem = (Element)mds.get(0);
            SpringConfigurationUtils.parseCustomElement(mdConfigElem, parserContext);
            builder.addPropertyValue("metadataProvider", (Object)new RuntimeBeanReference(mdConfigElem.getAttributeNS(null, "id")));
        }
        this.parseRelyingPartyConfiguration(configChildren, builder, parserContext);
        this.parseSecurityConfiguration(configChildren, builder, parserContext);
    }

    protected void parseRelyingPartyConfiguration(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder, ParserContext parserContext) {
        List<Element> anonRP = configChildren.get(RelyingPartyConfigurationBeanDefinitionParser.ANON_RP_ELEMENT_NAME);
        if (anonRP != null && anonRP.size() > 0) {
            builder.addPropertyValue("anonymousRP", (Object)SpringConfigurationUtils.parseInnerCustomElement(anonRP.get(0), parserContext));
        }
        List<Element> defaultRP = configChildren.get(RelyingPartyConfigurationBeanDefinitionParser.DEFAULT_RP_ELEMENT_NAME);
        builder.addPropertyValue("defaultRP", (Object)SpringConfigurationUtils.parseInnerCustomElement(defaultRP.get(0), parserContext));
        List<Element> rps = configChildren.get(RelyingPartyConfigurationBeanDefinitionParser.RP_ELEMENT_NAME);
        builder.addPropertyValue("relyingParties", (Object)SpringConfigurationUtils.parseInnerCustomElements(rps, parserContext));
    }

    protected void parseSecurityConfiguration(Map<QName, List<Element>> configChildren, BeanDefinitionBuilder builder, ParserContext parserContext) {
        List<Element> creds = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "Credential"));
        builder.addPropertyValue("credentials", (Object)SpringConfigurationUtils.parseInnerCustomElements(creds, parserContext));
        List<Element> engines = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "TrustEngine"));
        builder.addPropertyValue("trustEngines", (Object)SpringConfigurationUtils.parseInnerCustomElements(engines, parserContext));
        List<Element> secPols = configChildren.get(new QName("urn:mace:shibboleth:2.0:security", "SecurityPolicy"));
        builder.addPropertyValue("securityPolicies", (Object)SpringConfigurationUtils.parseInnerCustomElements(secPols, parserContext));
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

