/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.metadata;

import edu.internet2.middleware.shibboleth.common.config.metadata.BaseMetadataProviderBeanDefinitionParser;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class AbstractMetadataProviderBeanDefinitionParser
extends BaseMetadataProviderBeanDefinitionParser {
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProviderBeanDefinitionParser.class);

    protected void doParse(Element config, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        builder.setInitMethodName("initialize");
        String parserPoolRef = this.getParserPoolRef(config);
        this.log.debug("Metadata provider using parser pool: {}", (Object)parserPoolRef);
        builder.addPropertyReference("parserPool", parserPoolRef);
        boolean failFastInit = this.getFailFastInitialization(config);
        this.log.debug("Metadata provider fail fast initialization enabled: {}", (Object)failFastInit);
        builder.addPropertyValue("failFastInitialization", (Object)failFastInit);
    }

    protected String getParserPoolRef(Element config) {
        String parserPoolRef = null;
        if (config.hasAttributeNS(null, "parerPoolRef")) {
            parserPoolRef = DatatypeHelper.safeTrimOrNullString((String)config.getAttributeNS(null, "parserPoolRef"));
        }
        if (parserPoolRef == null) {
            parserPoolRef = "shibboleth.ParserPool";
        }
        return parserPoolRef;
    }

    protected boolean getFailFastInitialization(Element config) {
        boolean failFastInit = true;
        if (config.hasAttributeNS(null, "failFastInitialization")) {
            failFastInit = XMLHelper.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, "failFastInitialization"));
        }
        return failFastInit;
    }
}

