/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.provider;

import edu.internet2.middleware.shibboleth.common.attribute.AttributeRequestException;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethAttributeFilteringEngine;
import edu.internet2.middleware.shibboleth.common.attribute.provider.SAML1AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethAttributeResolver;
import edu.internet2.middleware.shibboleth.common.config.BaseService;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import edu.internet2.middleware.shibboleth.common.relyingparty.provider.saml1.AbstractSAML1ProfileConfiguration;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeDesignator;
import org.opensaml.saml1.core.AttributeQuery;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShibbolethSAML1AttributeAuthority
extends BaseService
implements SAML1AttributeAuthority {
    private final Logger log = LoggerFactory.getLogger(ShibbolethSAML1AttributeAuthority.class);
    private SAMLObjectBuilder<AttributeStatement> statementBuilder;
    private ShibbolethAttributeResolver attributeResolver;
    private ShibbolethAttributeFilteringEngine filteringEngine;

    public ShibbolethSAML1AttributeAuthority(ShibbolethAttributeResolver resolver) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        this.statementBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        this.attributeResolver = resolver;
    }

    public ShibbolethAttributeResolver getAttributeResolver() {
        return this.attributeResolver;
    }

    public ShibbolethAttributeFilteringEngine getFilteringEngine() {
        return this.filteringEngine;
    }

    public void setFilteringEngine(ShibbolethAttributeFilteringEngine engine) {
        this.filteringEngine = engine;
    }

    @Override
    public AttributeStatement buildAttributeStatement(AttributeQuery query, Collection<BaseAttribute> attributes) throws AttributeEncodingException {
        Collection<Attribute> encodedAttributes = this.encodeAttributes(attributes);
        if (encodedAttributes != null && !encodedAttributes.isEmpty()) {
            AttributeStatement statement = (AttributeStatement)this.statementBuilder.buildObject();
            statement.getAttributes().addAll(encodedAttributes);
            return statement;
        }
        this.log.debug("No attributes were encoded, no attribute statement created.");
        return null;
    }

    @Override
    public String getAttributeIDBySAMLAttribute(AttributeDesignator attribute) {
        return null;
    }

    @Override
    public String getPrincipal(SAMLProfileRequestContext<? extends SAMLObject, ? extends ResponseAbstractType, NameIdentifier, ? extends AbstractSAML1ProfileConfiguration> requestContext) throws AttributeRequestException {
        if (requestContext.getInboundMessageIssuer() == null || requestContext.getSubjectNameIdentifier() == null) {
            throw new AttributeRequestException("Unable to resolve principal, attribute requester ID and subject name identifier may not be null");
        }
        return this.attributeResolver.resolvePrincipalName(requestContext);
    }

    @Override
    public AttributeDesignator getSAMLAttributeByAttributeID(String id) {
        return null;
    }

    @Override
    public Map<String, BaseAttribute> getAttributes(SAMLProfileRequestContext<? extends SAMLObject, ? extends ResponseAbstractType, NameIdentifier, ? extends AbstractSAML1ProfileConfiguration> requestContext) throws AttributeRequestException {
        HashSet<String> requestedAttributes = new HashSet<String>();
        Set<String> queryAttributeIds = this.getAttributeIds(requestContext.getInboundSAMLMessage());
        requestedAttributes.addAll(queryAttributeIds);
        Set<String> metadataAttributeIds = this.getAttribtueIds(requestContext.getPeerEntityMetadata());
        requestedAttributes.addAll(metadataAttributeIds);
        requestContext.setRequestedAttributes(requestedAttributes);
        Map<String, BaseAttribute> attributes = this.attributeResolver.resolveAttributes(requestContext);
        if (this.filteringEngine != null) {
            attributes = this.filteringEngine.filterAttributes(attributes, requestContext);
        }
        return attributes;
    }

    protected Set<String> getAttributeIds(SAMLObject samlRequest) {
        Set<String> queryAttributeIds = new HashSet<String>();
        if (!(samlRequest instanceof AttributeQuery)) {
            return queryAttributeIds;
        }
        AttributeQuery query = (AttributeQuery)samlRequest;
        if (query != null) {
            List queryAttributes = query.getAttributeDesignators();
            queryAttributeIds = this.getAttributeIds(queryAttributes);
            this.log.debug("query message contains the following attributes: {}", queryAttributeIds);
        }
        return queryAttributeIds;
    }

    protected Set<String> getAttribtueIds(EntityDescriptor metadata) {
        HashSet<String> metadataAttributeIds = new HashSet<String>();
        return metadataAttributeIds;
    }

    protected Set<String> getAttributeIds(List<AttributeDesignator> attributes) {
        HashSet<String> attributeIds = new HashSet<String>();
        for (AttributeDesignator a : attributes) {
            String attrId = this.getAttributeIDBySAMLAttribute(a);
            attributeIds.add(attrId);
        }
        return attributeIds;
    }

    protected Collection<Attribute> encodeAttributes(Collection<BaseAttribute> attributes) {
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>();
        boolean attributeEncoded = false;
        for (BaseAttribute shibbolethAttribute : attributes) {
            if (shibbolethAttribute.getValues() == null || shibbolethAttribute.getValues().size() == 0) continue;
            for (AttributeEncoder encoder : shibbolethAttribute.getEncoders()) {
                if (!(encoder instanceof SAML1AttributeEncoder)) continue;
                try {
                    Attribute attribute = (Attribute)encoder.encode(shibbolethAttribute);
                    if (attribute == null) continue;
                    encodedAttributes.add(attribute);
                    attributeEncoded = true;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Encoded attribute {} with encoder of type {}", (Object)shibbolethAttribute.getId(), (Object)encoder.getClass().getName());
                }
                catch (AttributeEncodingException e) {
                    this.log.warn("Unable to encode attribute: {}", (Object)shibbolethAttribute.getId(), (Object)e);
                }
            }
            if (attributeEncoded) continue;
            this.log.debug("Attribute {} was not encoded because no SAML1AttributeEncoder was attached to it.", (Object)shibbolethAttribute.getId());
        }
        return encodedAttributes;
    }

    @Override
    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
    }
}

