/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.saml;

import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.FilterProcessingException;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.ShibbolethFilteringContext;
import edu.internet2.middleware.shibboleth.common.attribute.filtering.provider.match.basic.AbstractMatchFunctor;
import java.util.List;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.samlext.saml2mdattr.EntityAttributes;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityAttributeMatchFunctor
extends AbstractMatchFunctor {
    private final Logger log = LoggerFactory.getLogger(AbstractEntityAttributeMatchFunctor.class);
    private String name;
    private String nameFormat;

    public String getName() {
        return this.name;
    }

    public void setName(String attributeName) {
        this.name = attributeName;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(String attributeNameFormat) {
        this.nameFormat = DatatypeHelper.safeTrimOrNullString((String)attributeNameFormat);
    }

    protected boolean doEvaluatePolicyRequirement(ShibbolethFilteringContext filterContext) throws FilterProcessingException {
        return this.hasEntityAttribute(filterContext);
    }

    protected boolean doEvaluateValue(ShibbolethFilteringContext filterContext, String attributeId, Object attributeValue) throws FilterProcessingException {
        return this.hasEntityAttribute(filterContext);
    }

    protected boolean hasEntityAttribute(ShibbolethFilteringContext filterContext) {
        EntityDescriptor entityDescriptor = this.getEntityMetadata(filterContext);
        if (entityDescriptor == null) {
            this.log.debug("No metadata available for the entity");
            return false;
        }
        Attribute entityAttribute = this.getEntityAttribute(entityDescriptor);
        if (entityAttribute == null) {
            return false;
        }
        List attributeValues = entityAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Entity attribute {} for entity {} does not contain any values", (Object)this.getName(), (Object)entityDescriptor.getEntityID());
            return false;
        }
        this.log.debug("Checking if entity attribute {} contains the required value.", (Object)this.getName());
        for (XMLObject attributeValue : attributeValues) {
            String valueString;
            if (attributeValue instanceof XSAny) {
                valueString = ((XSAny)attributeValue).getTextContent();
            } else if (attributeValue instanceof XSString) {
                valueString = ((XSString)attributeValue).getValue();
            } else {
                this.log.debug("Entity attribute {} contains the unsupported value type {}, skipping it", (Object)this.getName(), (Object)attributeValue.getClass().getName());
                continue;
            }
            if (valueString == null) continue;
            if (this.entityAttributeValueMatches(valueString)) {
                this.log.debug("Entity attribute {} value {} meets matching requirements", (Object)this.getName(), (Object)valueString);
                return true;
            }
            this.log.debug("Entity attribute {} value {} does not meet matching requirements", (Object)this.getName(), (Object)valueString);
        }
        return false;
    }

    protected abstract EntityDescriptor getEntityMetadata(ShibbolethFilteringContext var1);

    protected Attribute getEntityAttribute(EntityDescriptor entityDescriptor) {
        List entityAttributes;
        List entityAttributesCollection = entityDescriptor.getExtensions().getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        if (entityAttributesCollection == null || entityAttributesCollection.isEmpty()) {
            this.log.debug("Descriptor for {} does not contain any EntityAttributes", (Object)entityDescriptor.getEntityID());
            return null;
        }
        if (entityAttributesCollection.size() > 1) {
            this.log.debug("Descriptor for {} contains more than EntityAttributes extension, only using the first one", (Object)entityDescriptor.getEntityID());
        }
        if ((entityAttributes = ((EntityAttributes)entityAttributesCollection.get(0)).getAttributes()) == null || entityAttributes.isEmpty()) {
            this.log.debug("EntityAttributes extension for {} does not contain any Attributes", (Object)entityDescriptor.getEntityID());
            return null;
        }
        for (Attribute entityAttribute : entityAttributes) {
            if (!DatatypeHelper.safeEquals((Object)this.getName(), (Object)entityAttribute.getName()) || this.getNameFormat() != null && !DatatypeHelper.safeEquals((Object)this.getNameFormat(), (Object)entityAttribute.getNameFormat())) continue;
            this.log.debug("Descriptor for {} contains an entity attribute with the name {} and the format {}", new Object[]{entityDescriptor.getEntityID(), this.getName(), this.getNameFormat()});
            return entityAttribute;
        }
        this.log.debug("Descriptor for {} does not contain an entity attribute with the name {} and the format {}", new Object[]{entityDescriptor.getEntityID(), this.getName(), this.getNameFormat()});
        return null;
    }

    protected abstract boolean entityAttributeValueMatches(String var1);
}

