/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.idp.ui;

import edu.internet2.middleware.shibboleth.idp.ui.ServiceTagSupport;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.opensaml.samlext.saml2mdui.InformationURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInformationURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = 5601822745575892676L;
    private static Logger log = LoggerFactory.getLogger(ServiceInformationURLTag.class);
    private static String linkText;

    public void setLinkText(String text) {
        linkText = text;
    }

    private String getInformationURLFromUIIinfo() {
        String lang = this.getBrowserLanguage();
        if (this.getSPUIInfo() != null && this.getSPUIInfo().getInformationURLs() != null) {
            for (InformationURL infoURL : this.getSPUIInfo().getInformationURLs()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found InformationURL in UIInfo, language=" + infoURL.getXMLLang());
                }
                if (!infoURL.getXMLLang().equals(lang)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("returning URL from UIInfo " + infoURL.getURI().getLocalString());
                }
                return infoURL.getURI().getLocalString();
            }
            if (log.isDebugEnabled()) {
                log.debug("No relevant InformationURL in UIInfo");
            }
        }
        return null;
    }

    public int doEndTag() throws JspException {
        String infoURL = this.getInformationURLFromUIIinfo();
        try {
            if (null == infoURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(infoURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating Description");
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

